/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.impl.TypeBoundNode;
import org.openl.binding.impl.component.ComponentBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.algorithm.DecisionTableOptimizedAlgorithm;
import org.openl.rules.dt.algorithm.DependentParametersOptimizedAlgorithm;
import org.openl.rules.dt.algorithm.ExpressionTypeUtils;
import org.openl.rules.dt.algorithm.IAlgorithmBuilder;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm.TwoDimensionalAlgorithm;
import org.openl.rules.dt.algorithm.evaluator.DefaultConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.data.DecisionTableDataType;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.RuleRow;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.ParameterMethodCaller;
import org.openl.types.impl.SourceCodeMethodCaller;
import org.openl.types.java.JavaOpenClass;

public class DecisionTableAlgorithmBuilder
implements IAlgorithmBuilder {
    protected IndexInfo baseInfo;
    protected DecisionTable table;
    protected IConditionEvaluator[] evaluators;
    IOpenMethodHeader header;
    OpenL openl;
    ComponentOpenClass componentOpenClass;
    ComponentOpenClass module;
    IBindingContextDelegator bindingContextDelegator;
    IMethodSignature signature;
    private RuleRow ruleRow;

    public DecisionTableAlgorithmBuilder(DecisionTable decisionTable, IOpenMethodHeader header, OpenL openl, ComponentOpenClass module, IBindingContextDelegator bindingContextDelegator) {
        this.table = decisionTable;
        this.header = header;
        this.signature = header.getSignature();
        this.openl = openl;
        this.module = module;
        this.bindingContextDelegator = bindingContextDelegator;
        this.ruleRow = this.table.getRuleRow();
    }

    public IDecisionTableAlgorithm buildAlgorithm() throws SyntaxNodeException {
        if (this.isTwoDimensional(this.table)) {
            IDecisionTableAlgorithm va = this.makeVerticalAlgorithm();
            IDecisionTableAlgorithm ha = this.makeHorizontalAlgorithm();
            TwoDimensionalAlgorithm twoD = new TwoDimensionalAlgorithm(va, ha);
            return twoD;
        }
        return this.makeFullAlgorithm();
    }

    protected IDecisionTableAlgorithm makeHorizontalAlgorithm() throws SyntaxNodeException {
        IndexInfo hInfo = this.baseInfo.makeHorizontalalInfo();
        return new DecisionTableOptimizedAlgorithm(this.evaluators, this.table, hInfo);
    }

    protected IDecisionTableAlgorithm makeFullAlgorithm() throws SyntaxNodeException {
        return new DecisionTableOptimizedAlgorithm(this.evaluators, this.table, this.baseInfo);
    }

    protected IDecisionTableAlgorithm makeVerticalAlgorithm() throws SyntaxNodeException {
        IndexInfo vInfo = this.baseInfo.makeVerticalInfo();
        return new DecisionTableOptimizedAlgorithm(this.evaluators, this.table, vInfo);
    }

    protected boolean isTwoDimensional(DecisionTable table2) {
        return this.table.getDtInfo().getNumberHConditions() > 0;
    }

    @Override
    public IDecisionTableAlgorithm prepareAndBuildAlgorithm() throws Exception {
        this.evaluators = this.prepareConditions();
        this.prepareActions();
        this.baseInfo = new IndexInfo().withTable(this.table);
        return this.buildAlgorithm();
    }

    protected DecisionTableDataType getRuleExecutionType(OpenL openl) {
        return new DecisionTableDataType(this.table, this.table.getName() + "Type", openl);
    }

    protected void prepareActions() throws Exception {
        DecisionTableDataType ruleExecutionType = this.getRuleExecutionType(this.openl);
        ComponentBindingContext actionBindingContextDelegator = new ComponentBindingContext((IBindingContext)this.bindingContextDelegator, (ComponentOpenClass)ruleExecutionType);
        int nActions = this.table.getNumberOfActions();
        for (int i = 0; i < nActions; ++i) {
            IAction action = this.table.getAction(i);
            this.prepareAction(action, (IBindingContextDelegator)actionBindingContextDelegator, ruleExecutionType);
        }
    }

    protected void prepareAction(IAction action, IBindingContextDelegator actionBindingContextDelegator, DecisionTableDataType ruleExecutionType) throws Exception {
        JavaOpenClass methodType = action.isReturnAction() ? this.header.getType() : JavaOpenClass.VOID;
        action.prepareAction((IOpenClass)methodType, this.signature, this.openl, this.componentOpenClass, actionBindingContextDelegator, this.ruleRow, (IOpenClass)ruleExecutionType);
    }

    protected IConditionEvaluator[] prepareConditions() throws Exception {
        int nConditions = this.table.getNumberOfConditions();
        IConditionEvaluator[] evaluators = new IConditionEvaluator[nConditions];
        ArrayList<SyntaxNodeException> errors = new ArrayList<SyntaxNodeException>();
        for (int i = 0; i < nConditions; ++i) {
            try {
                ICondition condition = this.table.getCondition(i);
                evaluators[i] = this.prepareCondition(condition);
                continue;
            }
            catch (SyntaxNodeException e) {
                errors.add(e);
                continue;
            }
            catch (CompositeSyntaxNodeException e) {
                for (SyntaxNodeException syntaxNodeException : e.getErrors()) {
                    errors.add(syntaxNodeException);
                }
            }
        }
        if (!errors.isEmpty()) {
            throw new CompositeSyntaxNodeException("Error:", errors.toArray(new SyntaxNodeException[0]));
        }
        return evaluators;
    }

    protected IConditionEvaluator prepareCondition(ICondition condition) throws Exception {
        condition.prepare((IOpenClass)NullOpenClass.the, this.signature, this.openl, this.componentOpenClass, this.bindingContextDelegator, this.ruleRow);
        IBoundMethodNode methodNode = ((CompositeMethod)condition.getMethod()).getMethodBodyBoundNode();
        IOpenSourceCodeModule source = methodNode.getSyntaxNode().getModule();
        if (StringUtils.isEmpty((CharSequence)source.getCode())) {
            throw SyntaxNodeExceptionUtils.createError((String)"Cannot execute empty expression", (IOpenSourceCodeModule)source);
        }
        if (methodNode.getChildren().length == 1 && methodNode.getChildren()[0].getChildren()[0] instanceof TypeBoundNode) {
            String message = String.format("Cannot execute expression with only type definition %s", source.getCode());
            throw SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)source);
        }
        IOpenClass methodType = ((CompositeMethod)condition.getMethod()).getBodyType();
        IConditionEvaluator conditionEvaluator = condition.getConditionEvaluator();
        IMethodCaller evaluator = condition.getEvaluator();
        if (condition.isDependentOnAnyParams()) {
            if (methodType != JavaOpenClass.BOOLEAN && methodType != JavaOpenClass.getOpenClass(Boolean.class)) {
                throw SyntaxNodeExceptionUtils.createError((String)"Condition must have boolean type if it depends on it's parameters", (IOpenSourceCodeModule)source);
            }
            conditionEvaluator = DependentParametersOptimizedAlgorithm.makeEvaluator(condition, this.signature, (IBindingContext)this.bindingContextDelegator);
            condition.setConditionEvaluator(conditionEvaluator);
            if (conditionEvaluator != null) {
                evaluator = this.makeOptimizedConditionMethodEvaluator(condition, this.signature, conditionEvaluator.getOptimizedSourceCode());
                condition.setEvaluator(evaluator);
                if (evaluator == null) {
                    evaluator = this.makeDependentParamsIndexedConditionMethodEvaluator(condition, this.signature, conditionEvaluator.getOptimizedSourceCode());
                    condition.setEvaluator(evaluator);
                }
                return conditionEvaluator;
            }
            conditionEvaluator = new DefaultConditionEvaluator();
            condition.setConditionEvaluator(conditionEvaluator);
            return conditionEvaluator;
        }
        IConditionEvaluator dtcev = DecisionTableOptimizedAlgorithm.makeEvaluator(condition, methodType, (IBindingContext)this.bindingContextDelegator);
        evaluator = this.makeOptimizedConditionMethodEvaluator(condition, this.signature);
        condition.setEvaluator(evaluator);
        conditionEvaluator = dtcev;
        condition.setConditionEvaluator(conditionEvaluator);
        return conditionEvaluator;
    }

    protected IMethodCaller makeOptimizedConditionMethodEvaluator(ICondition condition, IMethodSignature signature) {
        String code = ((CompositeMethod)condition.getMethod()).getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        return this.makeOptimizedConditionMethodEvaluator(condition, signature, code);
    }

    protected IMethodCaller makeOptimizedConditionMethodEvaluator(ICondition condition, IMethodSignature signature, String code) {
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            String pname = signature.getParameterName(i);
            if (!pname.equals(code)) continue;
            return new ParameterMethodCaller(condition.getMethod(), i);
        }
        return null;
    }

    protected IMethodCaller makeDependentParamsIndexedConditionMethodEvaluator(ICondition condition, IMethodSignature signature, String optimizedCode) {
        String v = ((CompositeMethod)condition.getMethod()).getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        if (optimizedCode != null && !optimizedCode.equals(v)) {
            String p = ExpressionTypeUtils.cutExpressionRoot(optimizedCode);
            for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
                String pname = signature.getParameterName(i);
                if (!pname.equals(p)) continue;
                IOpenClass type = ExpressionTypeUtils.findExpressionType(signature.getParameterType(i), optimizedCode);
                return new SourceCodeMethodCaller(signature, type, optimizedCode);
            }
        }
        return null;
    }
}

