/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.domain.IIntIterator;
import org.openl.domain.IIntSelector;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.algorithm.evaluator.AConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.ContainsInArraySelector;
import org.openl.rules.dt.algorithm.evaluator.FloatTypeComparator;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.rules.dt.index.EqualsIndex;
import org.openl.rules.dtx.IBaseCondition;
import org.openl.rules.helpers.NumberUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.types.IParameterDeclaration;
import org.openl.vm.IRuntimeEnv;

public class ContainsInArrayIndexedEvaluator
extends AConditionEvaluator
implements IConditionEvaluator {
    @Override
    public IOpenSourceCodeModule getFormalSourceCode(IBaseCondition condition) {
        IParameterDeclaration[] cparams = condition.getParams();
        IOpenSourceCodeModule conditionSource = condition.getSourceCodeModule();
        String code = String.format("containsCtr(%1$s, %2$s)", cparams[0].getName(), conditionSource.getCode());
        return new StringSourceCodeModule(code, conditionSource.getUri(0));
    }

    @Override
    public IIntSelector getSelector(ICondition condition, Object target, Object[] params, IRuntimeEnv env) {
        Object value = condition.getEvaluator().invoke(target, params, env);
        return new ContainsInArraySelector(condition, value, target, params, env);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public ARuleIndex makeIndex(ICondition condition, IIntIterator iterator) {
        if (iterator.size() < 1) {
            return null;
        }
        AbstractMap map = null;
        Map<Object, DecisionTableRuleNode> nodeMap = null;
        DecisionTableRuleNodeBuilder emptyBuilder = new DecisionTableRuleNodeBuilder();
        boolean comparatorBasedMap = false;
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            if (condition.isEmpty(i)) {
                emptyBuilder.addRule(i);
                if (map == null) continue;
                for (DecisionTableRuleNodeBuilder builder : map.values()) {
                    builder.addRule(i);
                }
                continue;
            }
            Object values = condition.getParamValue(0, i);
            int length = Array.getLength(values);
            for (int j = 0; j < length; ++j) {
                DecisionTableRuleNodeBuilder builder;
                Object value = Array.get(values, j);
                if (comparatorBasedMap && !(value instanceof Comparable)) {
                    throw new IllegalArgumentException("Invalid state! Index based on comparable interface!");
                }
                if (map == null) {
                    if (NumberUtils.isFloatPointNumber(value)) {
                        if (value instanceof BigDecimal) {
                            map = new TreeMap();
                            nodeMap = new TreeMap<Object, DecisionTableRuleNode>();
                        } else {
                            map = new TreeMap(FloatTypeComparator.getInstance());
                            nodeMap = new TreeMap<Object, DecisionTableRuleNode>(FloatTypeComparator.getInstance());
                        }
                        comparatorBasedMap = true;
                    } else {
                        map = new HashMap();
                        nodeMap = new HashMap<Object, DecisionTableRuleNode>();
                    }
                }
                if ((builder = (DecisionTableRuleNodeBuilder)map.get(value)) == null) {
                    builder = new DecisionTableRuleNodeBuilder(emptyBuilder);
                    map.put(value, builder);
                }
                builder.addRule(i);
            }
        }
        if (map != null) {
            for (Map.Entry element : map.entrySet()) {
                nodeMap.put(element.getKey(), ((DecisionTableRuleNodeBuilder)element.getValue()).makeNode());
            }
        } else {
            nodeMap = Collections.emptyMap();
        }
        return new EqualsIndex(emptyBuilder.makeNode(), nodeMap);
    }

    protected IDomain<Object> indexedDomain(IBaseCondition condition) {
        int len = condition.getNumberOfRules();
        ArrayList<Object> list = new ArrayList<Object>(len);
        HashSet<Object> set = new HashSet<Object>(len);
        for (int ruleN = 0; ruleN < len; ++ruleN) {
            if (condition.isEmpty(ruleN)) continue;
            Object ary = condition.getParamValue(0, ruleN);
            int plen = Array.getLength(ary);
            for (int j = 0; j < plen; ++j) {
                Object key = Array.get(ary, j);
                if (key == null || !set.add(key)) continue;
                list.add(key);
            }
        }
        EnumDomain ed = new EnumDomain(list.toArray());
        return ed;
    }
}

