/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.openl.domain.IDomain;
import org.openl.domain.IIntIterator;
import org.openl.domain.IIntSelector;
import org.openl.rules.dt.DecisionTableIndexedRuleNode;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.algorithm.evaluator.AConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.RangeSelector;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.rules.dt.index.RangeIndex;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.rules.dtx.IBaseCondition;
import org.openl.rules.dtx.algorithm.evaluator.DomainCanNotBeDefined;
import org.openl.rules.helpers.IntRange;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.types.IParameterDeclaration;
import org.openl.vm.IRuntimeEnv;

public class RangeIndexedEvaluator
extends AConditionEvaluator
implements IConditionEvaluator {
    private IRangeAdaptor<Object, ? extends Comparable<Object>> rangeAdaptor;
    int nparams;

    public RangeIndexedEvaluator(IRangeAdaptor<Object, ? extends Comparable<Object>> adaptor, int nparams) {
        this.rangeAdaptor = adaptor;
        this.nparams = nparams;
    }

    @Override
    public IOpenSourceCodeModule getFormalSourceCode(IBaseCondition condition) {
        if (this.rangeAdaptor != null && this.rangeAdaptor.useOriginalSource()) {
            return condition.getSourceCodeModule();
        }
        IParameterDeclaration[] cparams = condition.getParams();
        IOpenSourceCodeModule conditionSource = condition.getSourceCodeModule();
        String code = cparams.length == 2 ? String.format("%1$s<=(%2$s) && (%2$s) < %3$s", cparams[0].getName(), conditionSource.getCode(), cparams[1].getName()) : String.format("%1$s.contains(%2$s)", cparams[0].getName(), conditionSource.getCode());
        return new StringSourceCodeModule(code, conditionSource.getUri(0));
    }

    @Override
    public IIntSelector getSelector(ICondition condition, Object target, Object[] dtparams, IRuntimeEnv env) {
        Object value = condition.getEvaluator().invoke(target, dtparams, env);
        return new RangeSelector(condition, value, target, dtparams, this.rangeAdaptor, env);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public ARuleIndex makeIndex(ICondition condition, IIntIterator iterator) {
        if (iterator.size() < 1) {
            return null;
        }
        int size = iterator.size();
        ArrayList<Point<Object>> points = null;
        points = size != -1 ? new ArrayList(size) : new ArrayList();
        DecisionTableRuleNodeBuilder emptyBuilder = new DecisionTableRuleNodeBuilder();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            if (condition.isEmpty(i)) {
                emptyBuilder.addRule(i);
                continue;
            }
            Comparable<Object> vFrom = null;
            Comparable<Object> vTo = null;
            if (this.nparams == 2) {
                if (this.rangeAdaptor == null) {
                    vFrom = (Comparable<Object>)condition.getParamValue(0, i);
                    vTo = (Comparable<Object>)condition.getParamValue(1, i);
                } else {
                    vFrom = this.rangeAdaptor.getMin(condition.getParamValue(0, i));
                    vTo = this.rangeAdaptor.getMax(condition.getParamValue(1, i));
                }
            } else if (this.rangeAdaptor == null) {
                vFrom = (Comparable)condition.getParamValue(0, i);
                vTo = (Comparable)condition.getParamValue(0, i);
            } else {
                vFrom = this.rangeAdaptor.getMin(condition.getParamValue(0, i));
                vTo = this.rangeAdaptor.getMax(condition.getParamValue(0, i));
            }
            Integer v = i;
            Point vFromPoint = new Point();
            vFromPoint.v = vFrom;
            vFromPoint.isToPoint = false;
            vFromPoint.value = v;
            vFromPoint.isPositiveInfinity = false;
            Point vToPoint = new Point();
            vToPoint.v = vTo;
            vToPoint.isToPoint = true;
            vToPoint.value = v;
            vToPoint.isPositiveInfinity = true;
            points.add(vToPoint);
            points.add(vFromPoint);
        }
        Collections.sort(points);
        TreeSet<Integer> values = new TreeSet<Integer>();
        ArrayList index = new ArrayList();
        DecisionTableRuleNode emptyNode = emptyBuilder.makeNode();
        int length = points.size();
        for (int i = 0; i < length; ++i) {
            Point intervalPoint = (Point)points.get(i);
            if (!intervalPoint.isToPoint) {
                values.add((Integer)intervalPoint.value);
            } else {
                values.remove(intervalPoint.value);
            }
            if (i != length - 1 && intervalPoint.compareTo((Point)points.get(i + 1)) == 0) continue;
            Point indexedValue = intervalPoint;
            int[] rulesIndexesArray = null;
            rulesIndexesArray = emptyNode.getRules().length > 0 ? this.merge(values, emptyNode.getRules()) : this.collectionToPrimitiveArray(values);
            index.add(new DecisionTableIndexedRuleNode(rulesIndexesArray, indexedValue));
        }
        return new RangeIndex(emptyNode, index, new PointRangeAdaptor(this.rangeAdaptor));
    }

    private int[] collectionToPrimitiveArray(Collection<Integer> rulesIndexesCollection) {
        if (rulesIndexesCollection.isEmpty()) {
            return DecisionTableRuleNode.ZERO_ARRAY;
        }
        int[] rulesIndexesArray = new int[rulesIndexesCollection.size()];
        int i = 0;
        for (Integer value : rulesIndexesCollection) {
            rulesIndexesArray[i] = value;
            ++i;
        }
        return rulesIndexesArray;
    }

    private int[] merge(Collection<Integer> collection, int[] rules) {
        if (collection.isEmpty()) {
            return Arrays.copyOf(rules, rules.length);
        }
        int idx = 0;
        int n = collection.size() + rules.length;
        int[] result = new int[n];
        Iterator<Integer> itr = collection.iterator();
        int current = itr.next();
        boolean wasLast = false;
        for (int i = 0; i < n; ++i) {
            if (wasLast) {
                result[i] = rules[idx++];
                continue;
            }
            if (idx == rules.length) {
                result[i] = current;
                if (!itr.hasNext()) continue;
                current = itr.next();
                continue;
            }
            int value = rules[idx];
            if (current < value) {
                result[i] = current;
                if (itr.hasNext()) {
                    current = itr.next();
                    continue;
                }
                wasLast = true;
                continue;
            }
            result[i] = value;
            ++idx;
        }
        return result;
    }

    public IDomain<?> getConditionParameterDomain(int paramIdx, ICondition condition) throws DomainCanNotBeDefined {
        return null;
    }

    @Override
    protected IDomain<? extends Object> indexedDomain(IBaseCondition condition) throws DomainCanNotBeDefined {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int nRules = condition.getNumberOfRules();
        for (int ruleN = 0; ruleN < nRules; ++ruleN) {
            if (condition.isEmpty(ruleN)) continue;
            Comparable<Object> vFrom = null;
            Comparable<Object> vTo = null;
            if (this.nparams == 2) {
                if (this.rangeAdaptor == null) {
                    vFrom = (Comparable<Object>)condition.getParamValue(0, ruleN);
                    vTo = (Comparable<Object>)condition.getParamValue(1, ruleN);
                } else {
                    vFrom = this.rangeAdaptor.getMin(condition.getParamValue(0, ruleN));
                    vTo = this.rangeAdaptor.getMax(condition.getParamValue(1, ruleN));
                }
            } else {
                Object range = condition.getParamValue(0, ruleN);
                vFrom = this.rangeAdaptor.getMin(range);
                vTo = this.rangeAdaptor.getMax(range);
            }
            if (!(vFrom instanceof Integer)) {
                throw new DomainCanNotBeDefined("Domain can't be converted to Integer", null);
            }
            min = Math.min(min, (Integer)vFrom);
            max = Math.max(max, (Integer)vTo - 1);
        }
        return new IntRange(min, max);
    }

    public IRangeAdaptor<Object, ? extends Comparable<Object>> getRangeAdaptor() {
        return this.rangeAdaptor;
    }

    public int getNparams() {
        return this.nparams;
    }

    private static final class Point<K>
    implements Comparable<Point<K>> {
        private Comparable<Object> v;
        private boolean isPositiveInfinity = true;
        private K value;
        private boolean isToPoint;

        private Point() {
        }

        @Override
        public int compareTo(Point<K> o) {
            if (this.v == null && o.v == null) {
                if (this.isPositiveInfinity == o.isPositiveInfinity) {
                    return 0;
                }
                if (this.isPositiveInfinity) {
                    return 1;
                }
                return -1;
            }
            if (this.v == null) {
                if (this.isPositiveInfinity) {
                    return 1;
                }
                return -1;
            }
            if (o.v == null) {
                if (o.isPositiveInfinity) {
                    return -1;
                }
                return 1;
            }
            return this.v.compareTo(o.v);
        }
    }

    static class PointRangeAdaptor<K>
    implements IRangeAdaptor<Point<K>, Comparable<? extends Object>> {
        IRangeAdaptor<Object, ? extends Comparable<Object>> rangeAdaptor;

        public PointRangeAdaptor(IRangeAdaptor<Object, ? extends Comparable<Object>> rangeAdaptor) {
            this.rangeAdaptor = rangeAdaptor;
        }

        @Override
        public Comparable<? extends Object> adaptValueType(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("Null values doesn't supported!");
            }
            if (this.rangeAdaptor != null) {
                value = this.rangeAdaptor.adaptValueType(value);
            }
            Point point = new Point();
            point.v = value;
            return point;
        }

        @Override
        public Comparable<Object> getMax(Point<K> param) {
            throw new UnsupportedOperationException("Operation not supported!");
        }

        @Override
        public Comparable<Object> getMin(Point<K> param) {
            throw new UnsupportedOperationException("Operation not supported!");
        }

        @Override
        public boolean useOriginalSource() {
            throw new UnsupportedOperationException("Operation not supported!");
        }

        @Override
        public Class<?> getIndexType() {
            throw new UnsupportedOperationException("getIndexType fpr empty rangeAdaptors");
        }
    }
}

