/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm2;

import java.util.Iterator;
import org.openl.OpenL;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.domain.IIntIterator;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.algorithm.DecisionTableAlgorithmBuilder;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm.evaluator.ContainsInArrayIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.DefaultConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.EqualsIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.RangeIndexedEvaluator;
import org.openl.rules.dt.algorithm2.ConditionDescriptor;
import org.openl.rules.dt.algorithm2.DecisionTableSearchTree;
import org.openl.rules.dt.algorithm2.ISearchTreeNode;
import org.openl.rules.dt.algorithm2.NodeBuilder;
import org.openl.rules.dt.algorithm2.nodes.ContainsInArrayNodeBuilder;
import org.openl.rules.dt.algorithm2.nodes.DefaultNodeBuilder;
import org.openl.rules.dt.algorithm2.nodes.EqualsNodeBuilder;
import org.openl.rules.dt.algorithm2.nodes.RangeNodeBuilder;
import org.openl.rules.dt.algorithm2.nodes.SpecialNodeBuilder;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dtx.IBaseCondition;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenMethodHeader;

public class DecisionTableAlgorithmBuilder2
extends DecisionTableAlgorithmBuilder {
    NodeBuilder[] nodeBuilders;

    public DecisionTableAlgorithmBuilder2(DecisionTable decisionTable, IOpenMethodHeader header, OpenL openl, ComponentOpenClass module, IBindingContextDelegator bindingContextDelegator) {
        super(decisionTable, header, openl, module, bindingContextDelegator);
    }

    protected DecisionTableSearchTree buildSearchTree(IndexInfo info) throws SyntaxNodeException {
        int first = info.getFromCondition();
        int last = info.getToCondition();
        IBaseCondition[] cc = this.table.getConditionRows();
        if (cc.length <= first || first > last) {
            return new DecisionTableSearchTree(null, null, info);
        }
        this.nodeBuilders = this.makeNodeBuilders(first, last, info);
        ISearchTreeNode root = this.nodeBuilders[0].createNode();
        IIntIterator ruleIterator = info.makeRuleIterator();
        while (ruleIterator.hasNext()) {
            int ruleN = ruleIterator.nextInt();
            this.indexRule(ruleN, info, 0, root);
        }
        root = root.compactSearchNode();
        ConditionDescriptor[] descriptors = new ConditionDescriptor[this.nodeBuilders.length];
        for (int i = 0; i < descriptors.length; ++i) {
            descriptors[i] = this.nodeBuilders[i].makeDescriptor();
        }
        DecisionTableSearchTree searchTree = new DecisionTableSearchTree(root, descriptors, info);
        return searchTree;
    }

    private NodeBuilder[] makeNodeBuilders(int first, int last, IndexInfo info) {
        int len = last - first + 1;
        NodeBuilder[] nb = new NodeBuilder[len];
        for (int i = 0; i < len; ++i) {
            int idx = i + first;
            ICondition cond = this.table.getCondition(idx);
            boolean isFirst = idx == first;
            boolean isLast = idx == last;
            nb[i] = this.makeNodeBuilder(isFirst, isLast, cond, info);
            if (isFirst) continue;
            nb[i - 1].setNext(nb[i]);
        }
        return nb;
    }

    private NodeBuilder makeNodeBuilder(boolean isFirst, boolean isLast, ICondition cond, IndexInfo info) {
        IConditionEvaluator ce = cond.getConditionEvaluator();
        NodeBuilder nb = null;
        if (ce instanceof EqualsIndexedEvaluator) {
            nb = EqualsNodeBuilder.makeNodeBuilder(cond, isFirst, isLast);
        } else if (ce instanceof DefaultConditionEvaluator) {
            nb = DefaultNodeBuilder.makeNodeBuilder(cond, isFirst, isLast, info);
        } else if (ce instanceof RangeIndexedEvaluator) {
            nb = RangeNodeBuilder.makeNodeBuilder(cond, isFirst, isLast);
        } else if (ce instanceof ContainsInArrayIndexedEvaluator) {
            nb = ContainsInArrayNodeBuilder.makeNodeBuilder(cond, isFirst, isLast);
        } else {
            throw new UnsupportedOperationException("Evaluator: " + ce.getClass().getName());
        }
        if (cond.hasEmptyRules() || cond.hasSpecialRules()) {
            return new SpecialNodeBuilder(cond, isFirst, isLast, nb, info);
        }
        return nb;
    }

    private boolean indexRule(int ruleN, IndexInfo info, int nbIndex, ISearchTreeNode node) {
        NodeBuilder nb = this.nodeBuilders[nbIndex];
        if (nb.isLast) {
            return nb.indexRuleN(node, ruleN);
        }
        if (nb.isSingleNode(node, ruleN)) {
            ISearchTreeNode nextNode = nb.findOrCreateNextNode(node, ruleN);
            return this.indexRule(ruleN, info, nbIndex + 1, nextNode);
        }
        boolean res = false;
        Iterator<ISearchTreeNode> it = nb.findOrCreateNextNodes(node, ruleN);
        while (it.hasNext()) {
            ISearchTreeNode nextNode = it.next();
            res |= this.indexRule(ruleN, info, nbIndex + 1, nextNode);
        }
        return res;
    }

    @Override
    protected IDecisionTableAlgorithm makeHorizontalAlgorithm() throws SyntaxNodeException {
        IndexInfo hInfo = this.baseInfo.makeHorizontalalInfo();
        DecisionTableSearchTree alg = this.buildSearchTree(hInfo);
        return alg;
    }

    @Override
    protected IDecisionTableAlgorithm makeFullAlgorithm() throws SyntaxNodeException {
        DecisionTableSearchTree alg = this.buildSearchTree(this.baseInfo);
        return alg;
    }

    @Override
    protected IDecisionTableAlgorithm makeVerticalAlgorithm() throws SyntaxNodeException {
        IndexInfo vInfo = this.baseInfo.makeVerticalInfo();
        DecisionTableSearchTree alg = this.buildSearchTree(vInfo);
        return alg;
    }
}

