/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm2;

import org.openl.domain.IIntIterator;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm2.ConditionDescriptor;
import org.openl.rules.dt.algorithm2.ISearchTreeNode;
import org.openl.rules.dt.algorithm2.RuntimeContext;
import org.openl.rules.dt.algorithm2.SearchResult;
import org.openl.vm.IRuntimeEnv;

public class DecisionTableSearchTree
implements IDecisionTableAlgorithm {
    ConditionDescriptor[] descriptors;
    ISearchTreeNode root;
    private IndexInfo info;

    public DecisionTableSearchTree(ISearchTreeNode root, ConditionDescriptor[] descriptors, IndexInfo info) {
        this.root = root;
        this.descriptors = descriptors;
        this.info = info;
    }

    @Override
    public void removeParamValuesForIndexedConditions() {
    }

    @Override
    public IIntIterator checkedRules(Object target, Object[] params, IRuntimeEnv env) {
        if (this.root == null) {
            return this.info.makeRuleIterator();
        }
        SearchContext scxt = new SearchContext(target, params, env);
        return this.searchFirst(scxt);
    }

    public SearchResult searchNext(SearchContext scxt) {
        Object next = this.backtrack(scxt);
        if (next == null) {
            return SearchResult.notFound(scxt);
        }
        while (true) {
            if (scxt.currentConditionIdx + 1 == this.descriptors.length) {
                scxt.setValue(next);
                return SearchResult.found(scxt);
            }
            scxt.setNextNode(next);
            next = scxt.currentNode().findFirstNodeOrValue(scxt);
            if (next != null) continue;
            --scxt.currentConditionIdx;
            next = this.backtrack(scxt);
            if (next == null) break;
        }
        return SearchResult.notFound(scxt);
    }

    public SearchResult searchFirst(SearchContext scxt) {
        while (true) {
            Object next;
            if ((next = scxt.currentNode().findFirstNodeOrValue(scxt)) == null) {
                --scxt.currentConditionIdx;
                next = this.backtrack(scxt);
                if (next == null) {
                    return SearchResult.notFound(scxt);
                }
            }
            if (scxt.currentConditionIdx + 1 == this.descriptors.length) {
                scxt.setValue(next);
                return SearchResult.found(scxt);
            }
            scxt.setNextNode(next);
        }
    }

    private Object backtrack(SearchContext scxt) {
        while (scxt.currentConditionIdx >= 0) {
            ISearchTreeNode currentNode = scxt.currentNode();
            Object next = currentNode.findNextNodeOrValue(scxt);
            if (next != null) {
                return next;
            }
            --scxt.currentConditionIdx;
        }
        return null;
    }

    public final class SearchContext
    extends RuntimeContext {
        public int currentConditionIdx;
        private ISearchTreeNode[] savedNodes;
        Object[] indexedValues;
        Object[] storedValues;
        public int savedRuleN;

        public SearchContext(Object target, Object[] params, IRuntimeEnv env) {
            super(target, params, env);
            int len = DecisionTableSearchTree.this.descriptors.length;
            this.indexedValues = new Object[len];
            this.storedValues = new Object[len];
            this.savedNodes = new ISearchTreeNode[len];
            this.savedNodes[0] = DecisionTableSearchTree.this.root;
        }

        public void setNextNode(Object next) {
            this.savedNodes[++this.currentConditionIdx] = (ISearchTreeNode)next;
        }

        public void setValue(Object next) {
            this.savedRuleN = (Integer)next;
        }

        public final ISearchTreeNode currentNode() {
            return this.savedNodes[this.currentConditionIdx];
        }

        public SearchResult findNext() {
            return DecisionTableSearchTree.this.searchNext(this);
        }

        public Object getIndexedValue() {
            if (this.indexedValues[this.currentConditionIdx] == null) {
                ConditionDescriptor cd = DecisionTableSearchTree.this.descriptors[this.currentConditionIdx];
                if (!cd.useIndexedValue) {
                    return cd.evaluate(this);
                }
                this.indexedValues[this.currentConditionIdx] = cd.evaluate(this);
            }
            return this.indexedValues[this.currentConditionIdx];
        }

        public boolean calculateCondition(int ruleN) {
            return DecisionTableSearchTree.this.descriptors[this.currentConditionIdx].calculateCondition(ruleN, this);
        }

        public void store(Object x) {
            this.storedValues[this.currentConditionIdx] = x;
        }

        public Object retrieve() {
            return this.storedValues[this.currentConditionIdx];
        }
    }
}

