/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm2.nodes;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openl.rules.dt.algorithm.evaluator.RangeIndexedEvaluator;
import org.openl.rules.dt.algorithm2.ConditionDescriptor;
import org.openl.rules.dt.algorithm2.ISearchTreeNode;
import org.openl.rules.dt.algorithm2.NodeBuilder;
import org.openl.rules.dt.algorithm2.nodes.NodeBuilderN;
import org.openl.rules.dt.algorithm2.nodes.NodeBuilderV;
import org.openl.rules.dt.algorithm2.nodes.SearchNodeN;
import org.openl.rules.dt.algorithm2.nodes.SearchNodeV;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.util.trie.IARTNode;

public class RangeNodeBuilder {
    public static NodeBuilder makeNodeBuilder(ICondition cond, boolean isFirst, boolean isLast) {
        RangeIndexedEvaluator rix = (RangeIndexedEvaluator)cond.getConditionEvaluator();
        IRangeAdaptor<Object, ? extends Comparable<Object>> rangeAdaptor = rix.getRangeAdaptor();
        IRangeIndexMap map = RangeNodeBuilder.makeRangeIndexMap(cond, rangeAdaptor, rix);
        if (isFirst) {
            if (isLast) {
                return new RangeNodeBuiderVi(cond, isFirst, isLast, map, rangeAdaptor);
            }
            return new RangeNodeBuiderMN(cond, isFirst, isLast, map, rangeAdaptor);
        }
        if (isLast) {
            return new RangeNodeBuiderVi(cond, isFirst, isLast, map, rangeAdaptor);
        }
        return new RangeNodeBuiderMN(cond, isFirst, isLast, map, rangeAdaptor);
    }

    private static IRangeIndexMap makeRangeIndexMap(ICondition cond, IRangeAdaptor rangeAdaptor, RangeIndexedEvaluator rix) {
        Set<Comparable> uniqueRangeBounds;
        Class indexType = rangeAdaptor == null ? cond.getEvaluator().getMethod().getType().getInstanceClass() : rangeAdaptor.getIndexType();
        Set<Comparable> set = uniqueRangeBounds = rix.getNparams() == 1 ? RangeNodeBuilder.makeSingleParamUniqueBounds(cond, rix, rangeAdaptor) : RangeNodeBuilder.makeTwoParamUniqueBounds(cond, rix, rangeAdaptor);
        if (indexType == Integer.class) {
            return IntRangeIndexMap.makeMap(uniqueRangeBounds);
        }
        if (indexType == Double.class) {
            return DoubleRangeIndexMap.makeMap(uniqueRangeBounds);
        }
        return ComparableRangeIndexMap.makeMap(uniqueRangeBounds);
    }

    private static Set<Comparable> makeSingleParamUniqueBounds(ICondition cond, RangeIndexedEvaluator rix, IRangeAdaptor rangeAdaptor) {
        Map<Object, Integer> uniqueIndex = cond.getStorageInfo(0).getUniqueIndex();
        HashSet<Comparable> set = new HashSet<Comparable>();
        for (Object el : uniqueIndex.keySet()) {
            Object min = rangeAdaptor.getMin(el);
            Object max = rangeAdaptor.getMax(el);
            if (min != null) {
                set.add((Comparable)min);
            }
            if (max == null) continue;
            set.add((Comparable)max);
        }
        return set;
    }

    private static Set<Comparable> makeTwoParamUniqueBounds(ICondition cond, RangeIndexedEvaluator rix, IRangeAdaptor rangeAdaptor) {
        Object el;
        Map<Object, Integer> uniqueIndex0 = cond.getStorageInfo(0).getUniqueIndex();
        Map<Object, Integer> uniqueIndex1 = cond.getStorageInfo(1).getUniqueIndex();
        HashSet<Comparable> set = new HashSet<Comparable>();
        Iterator<Object> iterator = uniqueIndex0.keySet().iterator();
        while (iterator.hasNext()) {
            Object min = el = iterator.next();
            if (rangeAdaptor != null) {
                min = rangeAdaptor.getMin(min);
            }
            if (min == null) continue;
            set.add((Comparable)min);
        }
        iterator = uniqueIndex1.keySet().iterator();
        while (iterator.hasNext()) {
            Object max = el = iterator.next();
            if (rangeAdaptor != null) {
                max = rangeAdaptor.getMax(max);
            }
            if (max == null) continue;
            set.add((Comparable)max);
        }
        return set;
    }

    static class ComparableRangeIndexMap
    implements IRangeIndexMap {
        Comparable[] ary;

        public ComparableRangeIndexMap(Comparable[] ary) {
            this.ary = ary;
        }

        @Override
        public int findIndex(Object x) {
            int idx = Arrays.binarySearch(this.ary, (Comparable)x);
            return idx >= 0 ? idx + 1 : -(idx + 1);
        }

        static ComparableRangeIndexMap makeMap(Collection c) {
            Object[] ary = new Comparable[c.size()];
            Iterator it = c.iterator();
            for (int i = 0; i < ary.length; ++i) {
                ary[i] = (Comparable)it.next();
            }
            Arrays.sort(ary);
            return new ComparableRangeIndexMap((Comparable[])ary);
        }

        @Override
        public int size() {
            return this.ary.length + 1;
        }
    }

    static class DoubleRangeIndexMap
    implements IRangeIndexMap {
        double[] ary;

        public DoubleRangeIndexMap(double[] ary) {
            this.ary = ary;
        }

        @Override
        public int findIndex(Object x) {
            int idx = Arrays.binarySearch(this.ary, (Double)x);
            return idx >= 0 ? idx + 1 : -(idx + 1);
        }

        static DoubleRangeIndexMap makeMap(Collection c) {
            double[] ary = new double[c.size()];
            Iterator it = c.iterator();
            for (int i = 0; i < ary.length; ++i) {
                ary[i] = (Double)it.next();
            }
            Arrays.sort(ary);
            return new DoubleRangeIndexMap(ary);
        }

        @Override
        public int size() {
            return this.ary.length + 1;
        }
    }

    static class IntRangeIndexMap
    implements IRangeIndexMap {
        int[] ary;

        public IntRangeIndexMap(int[] ary) {
            this.ary = ary;
        }

        @Override
        public int findIndex(Object x) {
            int idx = Arrays.binarySearch(this.ary, (Integer)x);
            return idx >= 0 ? idx + 1 : -(idx + 1);
        }

        static IntRangeIndexMap makeMap(Collection c) {
            int[] ary = new int[c.size()];
            Iterator it = c.iterator();
            for (int i = 0; i < ary.length; ++i) {
                ary[i] = (Integer)it.next();
            }
            Arrays.sort(ary);
            return new IntRangeIndexMap(ary);
        }

        @Override
        public int size() {
            return this.ary.length + 1;
        }
    }

    public static interface IRangeIndexMap {
        public int findIndex(Object var1);

        public int size();
    }

    public static class RangeNodeBuiderMN
    extends NodeBuilderN {
        private IRangeIndexMap rangeMap;
        private IRangeAdaptor rangeAdaptor;

        public RangeNodeBuiderMN(ICondition condition, boolean isFirst, boolean isLast, IRangeIndexMap map, IRangeAdaptor rangeAdaptor) {
            super(condition, isFirst, isLast);
            this.rangeMap = map;
            this.rangeAdaptor = rangeAdaptor;
        }

        @Override
        public ConditionDescriptor makeDescriptor() {
            return new ConditionDescriptor.WithRangeMap(true, this.condition, this.rangeMap, this.rangeAdaptor);
        }

        @Override
        public boolean indexRuleN(ISearchTreeNode node, int ruleN) {
            throw new UnsupportedOperationException("indexRuleN");
        }

        @Override
        public ISearchTreeNode findOrCreateNextNode(ISearchTreeNode node, int ruleN) {
            throw new UnsupportedOperationException("findOrCreateNextNode");
        }

        @Override
        public ISearchTreeNode createNode() {
            return new SearchNodeN(new IARTNode[this.getNodesSize()]);
        }

        @Override
        public boolean isSingleNode(int ruleN) {
            return false;
        }

        @Override
        public Iterator<ISearchTreeNode> findOrCreateNextNodes(ISearchTreeNode node, int ruleN) {
            Comparable min = this.getMin(ruleN);
            Comparable max = this.getMax(ruleN);
            final int from = min == null ? 0 : this.rangeMap.findIndex(min);
            final int to = max == null ? this.rangeMap.size() : this.rangeMap.findIndex(max);
            final SearchNodeN snode = (SearchNodeN)node;
            return new Iterator<ISearchTreeNode>(){
                int current;
                {
                    this.current = from;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return this.current < to;
                }

                @Override
                public ISearchTreeNode next() {
                    ISearchTreeNode nextNode = (ISearchTreeNode)snode.findNode(this.current);
                    if (nextNode == null) {
                        nextNode = RangeNodeBuiderMN.this.next.createNode();
                        snode.setNode(this.current, nextNode);
                    }
                    ++this.current;
                    return nextNode;
                }
            };
        }

        private Comparable getMin(int ruleN) {
            Object value = this.condition.getParamValue(0, ruleN);
            return this.rangeAdaptor == null ? (Comparable)value : this.rangeAdaptor.getMin(value);
        }

        private Comparable getMax(int ruleN) {
            Object value = this.condition.getNumberOfParams() == 2 ? this.condition.getParamValue(1, ruleN) : this.condition.getParamValue(0, ruleN);
            return this.rangeAdaptor == null ? (Comparable)value : this.rangeAdaptor.getMax(value);
        }

        @Override
        protected int getNodesSize() {
            return this.rangeMap.size();
        }

        @Override
        protected int calculateNodeIndex(int ruleN) {
            throw new UnsupportedOperationException("calculateNodeIndex");
        }
    }

    public static class RangeNodeBuiderVi
    extends NodeBuilderV {
        private IRangeIndexMap rangeMap;
        private IRangeAdaptor rangeAdaptor;

        public RangeNodeBuiderVi(ICondition condition, boolean isFirst, boolean isLast, IRangeIndexMap map, IRangeAdaptor rangeAdaptor) {
            super(condition, isFirst, isLast);
            this.rangeMap = map;
            this.rangeAdaptor = rangeAdaptor;
        }

        @Override
        protected int calculateNodeIndex(int ruleN) {
            throw new UnsupportedOperationException("calculateNodeIndex");
        }

        @Override
        public ConditionDescriptor makeDescriptor() {
            return new ConditionDescriptor.WithRangeMap(true, this.condition, this.rangeMap, this.rangeAdaptor);
        }

        @Override
        protected int getNodesSize() {
            return this.rangeMap.size();
        }

        @Override
        public boolean isSingleNode(int ruleN) {
            return false;
        }

        @Override
        public Iterator<ISearchTreeNode> findOrCreateNextNodes(ISearchTreeNode node, int ruleN) {
            throw new UnsupportedOperationException("findOrCreateNextNodes");
        }

        @Override
        public boolean indexRuleN(ISearchTreeNode node, int ruleN) {
            Comparable min = this.getMin(ruleN);
            Comparable max = this.getMax(ruleN);
            int from = min == null ? 0 : this.rangeMap.findIndex(min);
            int to = max == null ? this.rangeMap.size() : this.rangeMap.findIndex(max);
            SearchNodeV vnode = (SearchNodeV)node;
            boolean res = false;
            for (int index = from; index < to; ++index) {
                Object oldValue = vnode.getValue(index);
                if (oldValue != null) continue;
                vnode.setValue(index, ruleN);
                res = true;
            }
            return res;
        }

        private Comparable getMin(int ruleN) {
            Object value = this.condition.getParamValue(0, ruleN);
            return this.rangeAdaptor == null ? (Comparable)value : this.rangeAdaptor.getMin(value);
        }

        private Comparable getMax(int ruleN) {
            Object value = this.condition.getNumberOfParams() == 2 ? this.condition.getParamValue(1, ruleN) : this.condition.getParamValue(0, ruleN);
            return this.rangeAdaptor == null ? (Comparable)value : this.rangeAdaptor.getMax(value);
        }
    }
}

