/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm2.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm2.ConditionDescriptor;
import org.openl.rules.dt.algorithm2.DecisionTableSearchTree;
import org.openl.rules.dt.algorithm2.ISearchTreeNode;
import org.openl.rules.dt.algorithm2.NodeBuilder;
import org.openl.rules.dt.algorithm2.nodes.BaseSearchNode;
import org.openl.rules.dt.algorithm2.nodes.DefaultNodeBuilder;
import org.openl.rules.dt.algorithm2.nodes.EmptyNodeBuilder;
import org.openl.rules.dt.element.ICondition;

public class SpecialNodeBuilder
extends NodeBuilder {
    private NodeBuilder nodeBuilder;
    private NodeBuilder emptyBuilder;
    private NodeBuilder formulaBuilder;

    public SpecialNodeBuilder(ICondition condition, boolean isFirst, boolean isLast, NodeBuilder nodeBuilder, IndexInfo info) {
        super(condition, isFirst, isLast);
        this.nodeBuilder = nodeBuilder;
        this.emptyBuilder = EmptyNodeBuilder.makeBuilder(condition, isFirst, isLast);
        this.formulaBuilder = DefaultNodeBuilder.makeNodeBuilder(condition, isFirst, isLast, info);
    }

    @Override
    public boolean indexRuleN(ISearchTreeNode node, int ruleN) {
        SpecialSearchTreeNodeForBuild snode = (SpecialSearchTreeNodeForBuild)node;
        this.selectCurrentBuilder(snode, ruleN);
        return snode.currentBuilder.indexRuleN(snode.last(), ruleN);
    }

    private void selectCurrentBuilder(SpecialSearchTreeNodeForBuild snode, int ruleN) {
        NodeBuilder newBuilder = null;
        newBuilder = this.condition.isEmpty(ruleN) ? this.emptyBuilder : (this.condition.hasFormula(ruleN) ? this.formulaBuilder : this.nodeBuilder);
        if (newBuilder != snode.currentBuilder) {
            ISearchTreeNode newCurrentNode = newBuilder.createNode();
            snode.addNode(newCurrentNode);
            snode.currentBuilder = newBuilder;
        }
    }

    @Override
    public boolean isSingleNode(int ruleN) {
        throw new UnsupportedOperationException("Should not call");
    }

    @Override
    public boolean isSingleNode(ISearchTreeNode node, int ruleN) {
        SpecialSearchTreeNodeForBuild snode = (SpecialSearchTreeNodeForBuild)node;
        this.selectCurrentBuilder(snode, ruleN);
        return snode.currentBuilder.isSingleNode(ruleN);
    }

    @Override
    public Iterator<ISearchTreeNode> findOrCreateNextNodes(ISearchTreeNode node, int ruleN) {
        SpecialSearchTreeNodeForBuild snode = (SpecialSearchTreeNodeForBuild)node;
        return snode.currentBuilder.findOrCreateNextNodes(snode.last(), ruleN);
    }

    @Override
    public ISearchTreeNode findOrCreateNextNode(ISearchTreeNode node, int ruleN) {
        SpecialSearchTreeNodeForBuild snode = (SpecialSearchTreeNodeForBuild)node;
        return snode.currentBuilder.findOrCreateNextNode(snode.last(), ruleN);
    }

    @Override
    public ISearchTreeNode createNode() {
        return new SpecialSearchTreeNodeForBuild();
    }

    @Override
    public ConditionDescriptor makeDescriptor() {
        return this.nodeBuilder.makeDescriptor();
    }

    @Override
    public void setNext(NodeBuilder next) {
        super.setNext(this.nodeBuilder);
        this.emptyBuilder.setNext(next);
        this.nodeBuilder.setNext(next);
        this.formulaBuilder.setNext(next);
    }

    static class SaveIndex {
        int index;
        Object save;

        public SaveIndex(int index, Object save) {
            this.index = index;
            this.save = save;
        }
    }

    public static class SpecialSearchTreeNodeForBuild
    extends BaseSearchNode {
        NodeBuilder currentBuilder;
        List<ISearchTreeNode> list = new ArrayList<ISearchTreeNode>();

        ISearchTreeNode last() {
            return this.list.size() == 0 ? null : this.list.get(this.list.size() - 1);
        }

        void addNode(ISearchTreeNode node) {
            this.list.add(node);
        }

        @Override
        public ISearchTreeNode compactSearchNode() {
            int n = this.list.size();
            ISearchTreeNode[] res = new ISearchTreeNode[n];
            for (int i = 0; i < n; ++i) {
                res[i] = this.list.get(i).compactSearchNode();
            }
            this.list = Arrays.asList(res);
            this.currentBuilder = null;
            return this;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.findFirstNodeOrValue(0, scxt);
        }

        public Object findFirstNodeOrValue(int start, DecisionTableSearchTree.SearchContext scxt) {
            for (int i = start; i < this.list.size(); ++i) {
                Object res = this.list.get(i).findFirstNodeOrValue(scxt);
                if (res == null) continue;
                scxt.store(new SaveIndex(i, scxt.retrieve()));
                return res;
            }
            return null;
        }

        @Override
        public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            SaveIndex si = (SaveIndex)scxt.retrieve();
            int index = si.index;
            scxt.store(si.save);
            Object res = this.list.get(index).findNextNodeOrValue(scxt);
            if (res != null) {
                scxt.store(new SaveIndex(index, scxt.retrieve()));
                return res;
            }
            return this.findFirstNodeOrValue(index + 1, scxt);
        }
    }
}

