/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.builder;

import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.dt.builder.IDecisionTableColumnBuilder;
import org.openl.rules.dt.builder.TableHeaderBuilder;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.Point;
import org.openl.rules.validation.properties.dimentional.Builder;

public class DecisionTableBuilder
implements Builder<IWritableGrid> {
    public static final int DECISION_TABLE_HEADER_ROWS_NUMBER = 5;
    public static final int CONDITION_TITLE_ROW_INDEX = 4;
    public static final int PARAMETER_DECLARATION_ROW_INDEX = 3;
    public static final int CODE_EXPRESSION_ROW_INDEX = 2;
    public static final int COLUMN_TYPE_ROW_INDEX = 1;
    private TableHeaderBuilder headerBuilder;
    private IDecisionTableColumnBuilder conditionsBuilder;
    private IDecisionTableColumnBuilder returnBuilder;
    private Point startPoint;
    private IWritableGrid sheetWithTable;
    private int rulesNumber;

    public DecisionTableBuilder(Point startPoint) {
        this.startPoint = startPoint;
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(Point startPoint) {
        this.startPoint = startPoint;
    }

    public TableHeaderBuilder getHeaderBuilder() {
        return this.headerBuilder;
    }

    public IDecisionTableColumnBuilder getConditionsBuilder() {
        return this.conditionsBuilder;
    }

    public IDecisionTableColumnBuilder getReturnBuilder() {
        return this.returnBuilder;
    }

    public void setHeaderBuilder(TableHeaderBuilder headerBuilder) {
        this.headerBuilder = headerBuilder;
    }

    public void setConditionsBuilder(IDecisionTableColumnBuilder conditionsBuilder) {
        this.conditionsBuilder = conditionsBuilder;
    }

    public void setReturnBuilder(IDecisionTableColumnBuilder returnBuilder) {
        this.returnBuilder = returnBuilder;
    }

    public IWritableGrid getSheetWithTable() {
        return this.sheetWithTable;
    }

    public void setSheetWithTable(IWritableGrid sheetWithTable) {
        this.sheetWithTable = sheetWithTable;
    }

    public void setRulesNumber(int rulesNumber) {
        this.rulesNumber = rulesNumber;
    }

    public IWritableGrid build(IWritableGrid sheet, int rulesNumber) {
        this.setSheetWithTable(sheet);
        this.setRulesNumber(rulesNumber);
        this.build();
        return this.getSheetWithTable();
    }

    @Override
    public IWritableGrid build() {
        if (this.conditionsBuilder == null) {
            throw new OpenlNotCheckedException("Condition builder cannot be null when building decision table");
        }
        int lastColumnIndex = this.conditionsBuilder.build(this.getSheetWithTable(), this.rulesNumber, this.startPoint.getColumn(), this.startPoint.getRow());
        if (this.returnBuilder == null) {
            throw new OpenlNotCheckedException("Return builder cannot be null when building decision table");
        }
        this.returnBuilder.build(this.getSheetWithTable(), this.rulesNumber, lastColumnIndex, this.startPoint.getRow());
        if (this.headerBuilder == null) {
            throw new OpenlNotCheckedException("Header builder cannot be null when building decision table");
        }
        this.headerBuilder.build(this.getSheetWithTable(), lastColumnIndex, this.startPoint.getColumn(), this.startPoint.getRow());
        return this.getSheetWithTable();
    }
}

