/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.data.RuleExecutionObject;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.table.ILogicalTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.types.IDynamicObject;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.vm.IRuntimeEnv;

public class Action
extends FunctionalRow
implements IAction {
    private boolean isReturnAction = false;
    private boolean isSingleReturnParam = false;
    private IOpenClass ruleExecutionType;

    public Action(String name, int row, ILogicalTable decisionTable, boolean isReturnAction, DTScale.RowScale scale) {
        super(name, row, decisionTable, scale);
        this.isReturnAction = isReturnAction;
    }

    @Override
    public boolean isAction() {
        return true;
    }

    @Override
    public boolean isCondition() {
        return false;
    }

    @Override
    public boolean isReturnAction() {
        return this.isReturnAction;
    }

    @Override
    public Object executeAction(int ruleN, Object target, Object[] params, IRuntimeEnv env) {
        if (target instanceof IDynamicObject) {
            target = new RuleExecutionObject(this.ruleExecutionType, (IDynamicObject)target, ruleN);
        }
        if (this.isSingleReturnParam) {
            if (this.isEmpty(ruleN)) {
                return null;
            }
            Object[] dest = new Object[this.getNumberOfParams()];
            this.loadValues(dest, 0, ruleN, target, params, env);
            Object returnValue = dest[0];
            CompositeMethod method = this.getMethod();
            IOpenClass returnType = method.getType();
            if (returnValue == null || ClassUtils.isAssignable(returnValue.getClass(), (Class)returnType.getInstanceClass(), (boolean)true)) {
                return returnValue;
            }
            return this.executeActionInternal(ruleN, target, params, env);
        }
        return this.executeActionInternal(ruleN, target, params, env);
    }

    private Object executeActionInternal(int ruleN, Object target, Object[] params, IRuntimeEnv env) {
        if (this.isEmpty(ruleN)) {
            return null;
        }
        return this.getMethod().invoke(target, this.mergeParams(target, params, env, ruleN), env);
    }

    @Override
    public void prepareAction(IOpenClass methodType, IMethodSignature signature, OpenL openl, ComponentOpenClass componentOpenClass, IBindingContextDelegator bindingContextDelegator, RuleRow ruleRow, IOpenClass ruleExecutionType) throws Exception {
        this.prepare(methodType, signature, openl, componentOpenClass, bindingContextDelegator, ruleRow);
        this.ruleExecutionType = ruleExecutionType;
        IParameterDeclaration[] params = this.getParams();
        CompositeMethod method = this.getMethod();
        String code = method.getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        this.isSingleReturnParam = params.length == 1 && params[0].getName().equals(code);
    }

    @Override
    protected IParameterDeclaration[] getParams(IOpenSourceCodeModule methodSource, IMethodSignature signature, IOpenClass declaringClass, IOpenClass methodType, OpenL openl, IBindingContext bindingContext) throws Exception {
        if ("extraRet".equals(methodSource.getCode()) && this.isReturnAction() && this.getParams() == null) {
            if (!bindingContext.isExecutionMode()) {
                this.setCellMetaInfo(0, methodType);
            }
            ParameterDeclaration extraParam = new ParameterDeclaration(methodType, "extraRet");
            IParameterDeclaration[] parameterDeclarations = new IParameterDeclaration[]{extraParam};
            this.setParams(parameterDeclarations);
            return this.getParams();
        }
        return super.getParams(methodSource, signature, declaringClass, methodType, openl, bindingContext);
    }

    @Override
    protected IOpenSourceCodeModule getExpressionSource(IBindingContext bindingContext) {
        IOpenSourceCodeModule source = super.getExpressionSource(bindingContext);
        if (this.isReturnAction() && StringUtils.isEmpty((CharSequence)source.getCode()) && this.getParams() == null) {
            return new StringSourceCodeModule("extraRet", source.getUri(0));
        }
        return super.getExpressionSource(bindingContext);
    }

    @Override
    public void removeDebugInformation() {
        this.getMethod().removeDebugInformation();
        if (this.storage != null) {
            for (IStorage st : this.storage) {
                int rules = st.size();
                for (int i = 0; i < rules; ++i) {
                    Object paramValue = st.getValue(i);
                    if (!(paramValue instanceof CompositeMethod)) continue;
                    ((CompositeMethod)paramValue).removeDebugInformation();
                }
            }
        }
    }
}

