/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.ReadOnlyStorage;
import org.openl.rules.dt.storage.StorageInfo;
import org.openl.rules.dt.storage.StorageUtils;

public abstract class MappedStorage
extends ReadOnlyStorage<Object> {
    Object[] uniqueValues;

    public MappedStorage(Object[] uniqueValues, StorageInfo info) {
        super(info);
        this.uniqueValues = uniqueValues;
    }

    @Override
    public Object getValue(int index) {
        return this.uniqueValues[this.mapIndex(index)];
    }

    protected abstract int mapIndex(int var1);

    @Override
    public boolean isSpace(int index) {
        return this.uniqueValues[this.mapIndex(index)] == null;
    }

    @Override
    public boolean isFormula(int index) {
        return StorageUtils.isFormula(this.uniqueValues[this.mapIndex(index)]);
    }

    @Override
    public boolean isElse(int index) {
        return this.uniqueValues[this.mapIndex(index)] == IStorage.StorageType.ELSE;
    }

    public static IStorage<Object> makeNewStorage(int[] map, Object[] uniqueValues, StorageInfo info) {
        int mapMaxValue = uniqueValues.length - 1;
        if (mapMaxValue <= 127) {
            return new ByteMappedStorage(map, uniqueValues, info);
        }
        if (mapMaxValue <= 255) {
            return new ByteExtMappedStorage(map, uniqueValues, info);
        }
        if (mapMaxValue <= Short.MAX_VALUE) {
            return new ShortMappedStorage(map, uniqueValues, info);
        }
        if (mapMaxValue <= 65535) {
            return new ShortExtMappedStorage(map, uniqueValues, info);
        }
        return new IntMappedStorage(map, uniqueValues, info);
    }

    static class IntMappedStorage
    extends MappedStorage {
        int[] map;

        public IntMappedStorage(int[] map, Object[] uniqueValues, StorageInfo info) {
            super(uniqueValues, info);
            this.map = map;
        }

        @Override
        public final int size() {
            return this.map.length;
        }

        @Override
        protected int mapIndex(int index) {
            return this.map[index];
        }
    }

    static class ShortExtMappedStorage
    extends MappedStorage {
        short[] bmap;

        public ShortExtMappedStorage(int[] map, Object[] uniqueValues, StorageInfo info) {
            super(uniqueValues, info);
            this.initMap(map);
        }

        protected void initMap(int[] map) {
            int size = map.length;
            this.bmap = new short[size];
            for (int i = 0; i < size; ++i) {
                this.bmap[i] = (short)(Short.MAX_VALUE - map[i]);
            }
        }

        @Override
        public final int size() {
            return this.bmap.length;
        }

        @Override
        protected int mapIndex(int index) {
            return Short.MAX_VALUE - this.bmap[index];
        }
    }

    static class ShortMappedStorage
    extends MappedStorage {
        short[] bmap;

        public ShortMappedStorage(int[] map, Object[] uniqueValues, StorageInfo info) {
            super(uniqueValues, info);
            this.initMap(map);
        }

        protected void initMap(int[] map) {
            int size = map.length;
            this.bmap = new short[size];
            for (int i = 0; i < size; ++i) {
                this.bmap[i] = (short)map[i];
            }
        }

        @Override
        public final int size() {
            return this.bmap.length;
        }

        @Override
        protected int mapIndex(int index) {
            return this.bmap[index];
        }
    }

    static class ByteExtMappedStorage
    extends MappedStorage {
        byte[] bmap;

        public ByteExtMappedStorage(int[] map, Object[] uniqueValues, StorageInfo info) {
            super(uniqueValues, info);
            this.initMap(map);
        }

        protected void initMap(int[] map) {
            int size = map.length;
            this.bmap = new byte[size];
            for (int i = 0; i < size; ++i) {
                this.bmap[i] = (byte)(127 - map[i]);
            }
        }

        @Override
        public final int size() {
            return this.bmap.length;
        }

        @Override
        protected int mapIndex(int index) {
            return 127 - this.bmap[index];
        }
    }

    static class ByteMappedStorage
    extends MappedStorage {
        byte[] bmap;

        public ByteMappedStorage(int[] map, Object[] uniqueValues, StorageInfo info) {
            super(uniqueValues, info);
            this.initMap(map);
        }

        protected void initMap(int[] map) {
            int size = map.length;
            this.bmap = new byte[size];
            for (int i = 0; i < size; ++i) {
                this.bmap[i] = (byte)map[i];
            }
        }

        @Override
        public final int size() {
            return this.bmap.length;
        }

        @Override
        protected int mapIndex(int index) {
            return this.bmap[index];
        }
    }
}

