/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.StorageInfo;
import org.openl.rules.dt.storage.StorageUtils;

public class ObjectStorage
implements IStorage<Object> {
    Object[] values;
    StorageInfo info;

    public ObjectStorage(int size) {
        this.values = new Object[size];
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Object getValue(int index) {
        return this.values[index];
    }

    @Override
    public boolean isSpace(int index) {
        return this.values[index] == null || this.values[index] == IStorage.StorageType.SPACE;
    }

    @Override
    public boolean isFormula(int index) {
        return StorageUtils.isFormula(this.values[index]);
    }

    @Override
    public boolean isElse(int index) {
        return this.values[index] == IStorage.StorageType.ELSE;
    }

    @Override
    public void setValue(int index, Object o) {
        this.values[index] = o;
    }

    @Override
    public void setSpace(int index) {
        this.values[index] = null;
    }

    @Override
    public void setElse(int index) {
        this.values[index] = IStorage.StorageType.ELSE;
    }

    @Override
    public void setFormula(int index, Object formula) {
        this.values[index] = formula;
    }

    @Override
    public StorageInfo getInfo() {
        return this.info;
    }

    public void setInfo(StorageInfo info) {
        this.info = info;
    }

    public Object[] getValues() {
        return this.values;
    }
}

