/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type;

import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.rules.helpers.DoubleRange;
import org.openl.util.RangeWithBounds;

public final class DoubleRangeAdaptor
implements IRangeAdaptor<DoubleRange, Double> {
    private static final DoubleRangeAdaptor INSTANCE = new DoubleRangeAdaptor();

    private DoubleRangeAdaptor() {
    }

    public static IRangeAdaptor<DoubleRange, Double> getInstance() {
        return INSTANCE;
    }

    @Override
    public Double getMax(DoubleRange range) {
        double max = range.getUpperBound();
        if (max != Double.POSITIVE_INFINITY && range.getUpperBoundType() == RangeWithBounds.BoundType.EXCLUDING) {
            max -= Math.ulp(max);
        } else if (max != Double.POSITIVE_INFINITY && range.getUpperBoundType() == RangeWithBounds.BoundType.INCLUDING) {
            max += Math.ulp(max);
        }
        return max;
    }

    @Override
    public Double getMin(DoubleRange range) {
        double min = range.getLowerBound();
        if (range.getLowerBoundType() == RangeWithBounds.BoundType.EXCLUDING) {
            min += Math.ulp(min);
        }
        return min;
    }

    @Override
    public Double adaptValueType(Object value) {
        return ((Number)value).doubleValue();
    }

    @Override
    public boolean useOriginalSource() {
        return false;
    }

    @Override
    public Class<?> getIndexType() {
        return Double.class;
    }
}

