/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type.domains;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openl.domain.DateRangeDomain;
import org.openl.rules.dt.type.domains.DateRangeDomainAdaptor;
import org.openl.rules.dt.type.domains.IDomainAdaptor;
import org.openl.rules.dt.type.domains.IDomainCollector;

public class DateDomainCollector
implements IDomainCollector {
    private Set<String> propertiesToSearch = new HashSet<String>();
    private List<Date> dateValues = new ArrayList<Date>();

    @Override
    public void gatherDomains(Map<String, Object> methodProperties) {
        if (methodProperties != null) {
            for (String propertyName : this.propertiesToSearch) {
                Date propValue = (Date)methodProperties.get(propertyName);
                if (propValue == null) continue;
                this.dateValues.add(propValue);
            }
        }
    }

    @Override
    public IDomainAdaptor getGatheredDomain() {
        if (!this.dateValues.isEmpty()) {
            Collections.sort(this.dateValues);
            DateRangeDomain domain = new DateRangeDomain(this.dateValues.get(0), this.dateValues.get(this.dateValues.size() - 1));
            return new DateRangeDomainAdaptor(domain);
        }
        return null;
    }

    public void addPropertyToSearch(String propertyToSearch) {
        this.propertiesToSearch.add(propertyToSearch);
    }
}

