/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openl.binding.BindingDependencies;
import org.openl.binding.ILocalVar;
import org.openl.domain.IDomain;
import org.openl.domain.IntRangeDomain;
import org.openl.domain.StringDomain;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.IDecisionRow;
import org.openl.rules.dt.validator.ConditionAnalyzer;
import org.openl.rules.dt.validator.DecisionTableParamDescription;
import org.openl.rules.dt.validator.IDecisionTableValidatedObject;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenFieldDelegator;
import org.openl.types.impl.ParameterDeclaration;

public class DecisionTableAnalyzer {
    private DecisionTable decisionTable;
    private Map<IDecisionRow, ConditionAnalyzer> conditionAnalyzers = new HashMap<IDecisionRow, ConditionAnalyzer>();
    private Map<String, DecisionTableParamDescription> usedParamsFromSignature = new HashMap<String, DecisionTableParamDescription>();

    public DecisionTableAnalyzer(DecisionTable decisionTable) {
        this.decisionTable = decisionTable;
        this.init(decisionTable);
    }

    private void init(DecisionTable decisionTable) {
        int n = decisionTable.getNumberOfConditions();
        for (int i = 0; i < n; ++i) {
            this.conditionAnalyzers.put(decisionTable.getCondition(i), new ConditionAnalyzer(decisionTable.getCondition(i)));
        }
    }

    public boolean containsFormula(IDecisionRow row) {
        int len = row.getNumberOfRules();
        for (int ruleN = 0; ruleN < len; ++ruleN) {
            if (!row.hasFormula(ruleN)) continue;
            return true;
        }
        return false;
    }

    public Iterator<DecisionTableParamDescription> tableParams() {
        return this.usedParamsFromSignature.values().iterator();
    }

    public DecisionTable getDecisionTable() {
        return this.decisionTable;
    }

    public IDomain<?> getParameterDomain(String parameterName, IDecisionRow condition) {
        return this.conditionAnalyzers.get(condition).getParameterDomain(parameterName);
    }

    public IDomain<?> getSignatureParameterDomain(String parameterName) {
        return this.usedParamsFromSignature.get(parameterName).getDomain();
    }

    public IDomain<?> gatherDomainFromValues(IParameterDeclaration parameter, ICondition condition) {
        StringDomain result = null;
        Class type = parameter.getType().getInstanceClass();
        if (String.class.equals((Object)type)) {
            result = this.gatherStringDomainFromValues(condition);
        } else if (Integer.TYPE.equals(type)) {
            result = this.gatherIntDomainFromValues(condition);
        }
        return result;
    }

    private StringDomain gatherStringDomainFromValues(ICondition condition) {
        int nRules = condition.getNumberOfRules();
        int np = condition.getNumberOfParams();
        String[] enumValues = new String[nRules * np];
        for (int ruleN = 0; ruleN < nRules; ++ruleN) {
            for (int pidx = 0; pidx < np; ++pidx) {
                enumValues[ruleN * np + pidx] = (String)condition.getParamValue(pidx, ruleN);
            }
        }
        return new StringDomain(enumValues);
    }

    private IntRangeDomain gatherIntDomainFromValues(ICondition condition) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int nRules = condition.getNumberOfRules();
        int np = condition.getNumberOfParams();
        for (int ruleN = 0; ruleN < nRules; ++ruleN) {
            if (condition.isEmpty(ruleN)) continue;
            for (int pidx = 0; pidx < np; ++pidx) {
                Integer cand = (Integer)condition.getParamValue(pidx, ruleN);
                if (min > cand) {
                    min = cand;
                    continue;
                }
                if (max >= cand) continue;
                max = cand;
            }
        }
        return new IntRangeDomain(min, max);
    }

    public IParameterDeclaration[] referencedSignatureParams(IDecisionRow row) {
        CompositeMethod method = (CompositeMethod)row.getMethod();
        RulesBindingDependencies bindingDependecies = new RulesBindingDependencies();
        method.updateDependency((BindingDependencies)bindingDependecies);
        IMethodSignature methodSignature = this.decisionTable.getSignature();
        ArrayList<ParameterDeclaration> paramDeclarations = new ArrayList<ParameterDeclaration>();
        for (IOpenField openField : bindingDependecies.getFieldsMap().values()) {
            IOpenField anotherOpenField = this.getLocalField(openField);
            if (!(anotherOpenField instanceof ILocalVar)) continue;
            for (int i = 0; i < methodSignature.getNumberOfParameters(); ++i) {
                ParameterDeclaration parameterDeclaration;
                if (!methodSignature.getParameterName(i).equals(anotherOpenField.getName()) || paramDeclarations.contains(parameterDeclaration = new ParameterDeclaration(methodSignature.getParameterTypes()[i], methodSignature.getParameterName(i)))) continue;
                paramDeclarations.add(parameterDeclaration);
            }
        }
        return paramDeclarations.toArray(new IParameterDeclaration[paramDeclarations.size()]);
    }

    public IOpenClass transformSignatureType(IParameterDeclaration paramDeclarationFromSignature, IDecisionTableValidatedObject decisionTableToValidate) {
        DecisionTableParamDescription paramDescription = this.usedParamsFromSignature.get(paramDeclarationFromSignature.getName());
        if (paramDescription == null) {
            IOpenClass newType = decisionTableToValidate.getTransformer().transformSignatureType(paramDeclarationFromSignature);
            paramDescription = new DecisionTableParamDescription(paramDeclarationFromSignature, newType);
            this.usedParamsFromSignature.put(paramDeclarationFromSignature.getName(), paramDescription);
        }
        return paramDescription.getNewType();
    }

    public Map<String, DecisionTableParamDescription> getUsedParams() {
        return this.usedParamsFromSignature;
    }

    private IOpenField getLocalField(IOpenField field) {
        if (field instanceof ILocalVar) {
            return field;
        }
        if (field instanceof OpenFieldDelegator) {
            OpenFieldDelegator delegator = (OpenFieldDelegator)field;
            return delegator.getField();
        }
        return field;
    }
}

