/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dtx.type.domains;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.dtx.type.domains.ArrayDomainCollector;
import org.openl.rules.dtx.type.domains.DateDomainCollector;
import org.openl.rules.dtx.type.domains.EnumDomainCollector;
import org.openl.rules.dtx.type.domains.IDomainAdaptor;
import org.openl.rules.dtx.type.domains.IDomainCollector;
import org.openl.rules.dtx.type.domains.StringDomainCollector;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;

public class DimensionPropertiesDomainsCollector {
    private Map<String, IDomainCollector> domainCollectors = new HashMap<String, IDomainCollector>();
    private Map<String, IDomainAdaptor> propertiesDomains = new HashMap<String, IDomainAdaptor>();
    private DateDomainCollector dateDomainCollector = new DateDomainCollector();
    protected static final String CURRENT_DATE_PARAM = "currentDate";

    public DimensionPropertiesDomainsCollector() {
        this.initDomainCollectors();
    }

    public Map<String, IDomainAdaptor> gatherPropertiesDomains(List<Map<String, Object>> methodsProperties) {
        this.gatherAllDomains(methodsProperties);
        this.applyAllDomains();
        return new HashMap<String, IDomainAdaptor>(this.propertiesDomains);
    }

    private void applyAllDomains() {
        this.propertiesDomains.clear();
        IDomainAdaptor dateDomainAdaptor = null;
        for (String propNeedDomain : this.domainCollectors.keySet()) {
            TablePropertyDefinition propDef = TablePropertyDefinitionUtils.getPropertyByName(propNeedDomain);
            Class propertyType = propDef.getType().getInstanceClass();
            IDomainCollector domainCollector = this.domainCollectors.get(propNeedDomain);
            this.applyDomain(propDef, domainCollector.getGatheredDomain());
            if (dateDomainAdaptor == null && Date.class.equals((Object)propertyType)) {
                dateDomainAdaptor = domainCollector.getGatheredDomain();
                continue;
            }
            if (!propertyType.isArray() || !propertyType.getComponentType().isEnum()) continue;
            this.applyArrayDomains(propNeedDomain, domainCollector);
        }
        this.applyCurrentDateDomain(dateDomainAdaptor);
    }

    private void applyArrayDomains(String propNeedDomain, IDomainCollector domainCollector) {
        ArrayDomainCollector arrayCollector = (ArrayDomainCollector)domainCollector;
        IDomainAdaptor domainAdaptor = arrayCollector.getGatheredDomain();
        if (domainAdaptor != null) {
            this.propertiesDomains.put(propNeedDomain, domainAdaptor);
            for (int i = 1; i <= arrayCollector.getNumberOfDomainElements(); ++i) {
                this.propertiesDomains.put(String.format("%s%s%s", propNeedDomain, "Local", i), domainAdaptor);
            }
        }
    }

    private void applyDomain(TablePropertyDefinition propDef, IDomainAdaptor gatheredDomain) {
        String propName = propDef.getName();
        String key = propName + "Local";
        if (gatheredDomain != null && !this.propertiesDomains.containsKey(key) && propDef.getExpression() != null) {
            this.propertiesDomains.put(propDef.getExpression().getMatchExpression().getContextAttribute(), gatheredDomain);
            this.propertiesDomains.put(propName, gatheredDomain);
            this.propertiesDomains.put(key, gatheredDomain);
        }
    }

    private void applyCurrentDateDomain(IDomainAdaptor dateDomainAdaptor) {
        if (dateDomainAdaptor != null && !this.propertiesDomains.containsKey(CURRENT_DATE_PARAM)) {
            this.propertiesDomains.put(CURRENT_DATE_PARAM, dateDomainAdaptor);
        }
    }

    private void gatherAllDomains(List<Map<String, Object>> methodsProperties) {
        for (Map<String, Object> methodProperties : methodsProperties) {
            for (String propNeedDomain : this.domainCollectors.keySet()) {
                IDomainCollector domainCollector = this.domainCollectors.get(propNeedDomain);
                domainCollector.gatherDomains(methodProperties);
            }
        }
    }

    private void initDomainCollectors() {
        for (TablePropertyDefinition property : TablePropertyDefinitionUtils.getDimensionalTableProperties()) {
            IDomainCollector domainCollector = this.getDomainCollector(property);
            if (domainCollector == null) continue;
            this.domainCollectors.put(property.getName(), domainCollector);
        }
    }

    private IDomainCollector getDomainCollector(TablePropertyDefinition property) {
        Class propertyType = property.getType().getInstanceClass();
        String propertyName = property.getName();
        IDomainCollector result = null;
        if (result == null) {
            if (Date.class.equals((Object)propertyType)) {
                this.dateDomainCollector.addPropertyToSearch(propertyName);
                result = this.dateDomainCollector;
            } else if (String.class.equals((Object)propertyType)) {
                result = new StringDomainCollector(propertyName);
            } else if (propertyType.isEnum()) {
                result = new EnumDomainCollector(propertyName);
            } else if (propertyType.isArray() && propertyType.getComponentType().isEnum()) {
                result = new ArrayDomainCollector(propertyName);
            } else if (propertyType.isArray() && String.class.equals(propertyType.getComponentType())) {
                result = new ArrayDomainCollector(propertyName);
            } else {
                String message = String.format("Can`t find domain for property \"%s\" of type \"%s\"", propertyName, propertyType.getSimpleName());
                OpenLMessagesUtils.addWarn((String)message);
            }
        }
        return result;
    }
}

