/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dtx.validator;

import org.openl.ie.constrainer.consistencyChecking.Overlapping;
import org.openl.util.ArrayOfNamedValues;
import org.openl.util.ArrayTool;

public class DecisionTableOverlapping {
    private int[] rulesIndexes;
    private ArrayOfNamedValues value;
    private Overlapping.OverlappingStatus status;

    public Overlapping.OverlappingStatus getStatus() {
        return this.status;
    }

    public DecisionTableOverlapping(int[] rulesIndexes, ArrayOfNamedValues value, Overlapping.OverlappingStatus status) {
        this.rulesIndexes = rulesIndexes;
        this.value = value;
        this.status = status;
    }

    public int[] getRulesIndexes() {
        return this.rulesIndexes;
    }

    public ArrayOfNamedValues getValues() {
        return this.value;
    }

    public String toString() {
        switch (this.status) {
            case BLOCK: {
                return String.format("Rule #%d completely blocks rule #%d. For example: %s", this.rulesIndexes[0], this.rulesIndexes[1], this.value.toString());
            }
            case PARTIAL: {
                return String.format("Rule #%d partially overlaps with rule #%d. For example:  %s", this.rulesIndexes[0], this.rulesIndexes[1], this.value.toString());
            }
            case OVERRIDE: {
                return String.format("Rule #%d overrides rule #%d. For example: %s", this.rulesIndexes[1], this.rulesIndexes[0], this.value.toString());
            }
        }
        return String.format("Rules with # %s overlap for values: %s", ArrayTool.asString((Object)this.rulesIndexes), this.value.toString());
    }
}

