/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dtx.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openl.ie.constrainer.consistencyChecking.Overlapping;
import org.openl.ie.constrainer.consistencyChecking.Uncovered;
import org.openl.rules.dtx.IDecisionTable;
import org.openl.rules.dtx.validator.DecisionTableAnalyzer;
import org.openl.rules.dtx.validator.DecisionTableOverlapping;
import org.openl.rules.dtx.validator.DecisionTableUncovered;
import org.openl.rules.dtx.validator.IConditionTransformer;
import org.openl.rules.validator.IValidationResult;
import org.openl.util.ArrayOfNamedValues;

public class DesionTableValidationResult
implements IValidationResult {
    private IDecisionTable decisionTable;
    private DecisionTableOverlapping[] overlappings;
    private DecisionTableUncovered[] uncovered;

    public DesionTableValidationResult(IDecisionTable decisionTable) {
        this.decisionTable = decisionTable;
        this.overlappings = new DecisionTableOverlapping[0];
        this.uncovered = new DecisionTableUncovered[0];
    }

    public DesionTableValidationResult(IDecisionTable decisionTable, Overlapping[] overlappings, Uncovered[] uncovered, IConditionTransformer transformer, DecisionTableAnalyzer analyzer) {
        this.decisionTable = decisionTable;
        this.overlappings = this.convertOverlappings(overlappings, transformer, analyzer);
        this.uncovered = this.convertUncovered(uncovered, transformer, analyzer);
    }

    private DecisionTableOverlapping[] convertOverlappings(Overlapping[] overlappings, IConditionTransformer transformer, DecisionTableAnalyzer analyzer) {
        DecisionTableOverlapping[] tableOverlappings = new DecisionTableOverlapping[overlappings.length];
        for (int i = 0; i < overlappings.length; ++i) {
            DecisionTableOverlapping tableOverlapping;
            String[] names = overlappings[i].getSolutionNames();
            Object[] values = new Object[names.length];
            for (int j = 0; j < values.length; ++j) {
                values[j] = transformer.transformSignatureValueBack(names[j], overlappings[i].getSolutionValues()[j], analyzer);
            }
            tableOverlappings[i] = tableOverlapping = new DecisionTableOverlapping(overlappings[i].getOverlapped(), new ArrayOfNamedValues(names, values), overlappings[i].getStatus());
        }
        return tableOverlappings;
    }

    private DecisionTableUncovered[] convertUncovered(Uncovered[] uncovered, IConditionTransformer transformer, DecisionTableAnalyzer analyzer) {
        DecisionTableUncovered[] tableUncovered = new DecisionTableUncovered[uncovered.length];
        for (int i = 0; i < uncovered.length; ++i) {
            String[] names = uncovered[i].getSolutionNames();
            Object[] values = new Object[names.length];
            for (int j = 0; j < values.length; ++j) {
                values[j] = transformer.transformSignatureValueBack(names[j], uncovered[i].getSolutionValues()[j], analyzer);
            }
            tableUncovered[i] = new DecisionTableUncovered(new ArrayOfNamedValues(names, values));
        }
        return tableUncovered;
    }

    public IDecisionTable getDecisionTable() {
        return this.decisionTable;
    }

    public DecisionTableOverlapping[] getOverlappings() {
        return this.overlappings;
    }

    public DecisionTableUncovered[] getUncovered() {
        return this.uncovered;
    }

    public boolean hasProblems() {
        return this.hasErrors() || this.hasWarnings();
    }

    public boolean hasErrors() {
        return this.getOverlappingBlocks().size() > 0 || this.uncovered != null && this.uncovered.length > 0;
    }

    public boolean hasWarnings() {
        return this.getOverlappingPartialOverlaps().size() > 0;
    }

    public List<DecisionTableOverlapping> getOverlappingBlocks() {
        return this.selectOverlappings(Overlapping.OverlappingStatus.BLOCK);
    }

    public List<DecisionTableOverlapping> getOverlappingPartialOverlaps() {
        return this.selectOverlappings(Overlapping.OverlappingStatus.PARTIAL);
    }

    public List<DecisionTableOverlapping> getOverlappingOverrides() {
        return this.selectOverlappings(Overlapping.OverlappingStatus.OVERRIDE);
    }

    private List<DecisionTableOverlapping> selectOverlappings(Overlapping.OverlappingStatus status) {
        ArrayList<DecisionTableOverlapping> res = new ArrayList<DecisionTableOverlapping>();
        if (this.overlappings == null) {
            return res;
        }
        for (int i = 0; i < this.overlappings.length; ++i) {
            if (this.overlappings[i].getStatus() != status) continue;
            res.add(this.overlappings[i]);
        }
        return res;
    }

    public String toString() {
        StringBuilder validationResultDetails = new StringBuilder();
        if (this.getUncovered().length > 0) {
            validationResultDetails.append(String.format("There is an uncovered case for values: %s\r\n", Arrays.asList(this.getUncovered())));
        }
        int maxCounter = 3;
        int cnt = 0;
        for (DecisionTableOverlapping ovl : this.getOverlappingBlocks()) {
            if (++cnt >= maxCounter) continue;
            validationResultDetails.append(ovl.toString()).append("\r\n");
        }
        for (DecisionTableOverlapping ovl : this.getOverlappingPartialOverlaps()) {
            if (++cnt > maxCounter) continue;
            validationResultDetails.append(ovl.toString()).append("\r\n");
        }
        for (DecisionTableOverlapping ovl : this.getOverlappingOverrides()) {
            if (++cnt > maxCounter) continue;
            validationResultDetails.append(ovl.toString()).append("\r\n");
        }
        if (cnt > maxCounter) {
            validationResultDetails.append(String.format("  %d more ...", cnt - maxCounter));
        }
        return validationResultDetails.toString();
    }
}

