/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.HashMap;
import java.util.Map;
import org.openl.rules.helpers.IntRange;

public class IntRangeParser2 {
    public static final String ERROR_OUT_RANGE = "Integer value is out of possible range";
    public static final String ERROR_NOT_NUMBER = "Number expected";
    static final int RANGE = 1000000;
    static final int RANGE_EXCLUSIVE = 1000001;
    static final int LE = 1000002;
    static final int GE = 1000003;
    static final int ID = 1000004;
    static final int KEYWORD = 1000005;
    static final int INT_VALUE = 1000006;
    static final int ILLEGAL = 0x7FFFFFFE;
    static final int EOS = Integer.MAX_VALUE;
    static final int KW_AND = 1000;
    static final int KW_LESS = 1001;
    static final int KW_MORE = 1002;
    static final int KW_OR = 1003;
    static final int KW_THAN = 1004;
    static final Map<String, Integer> keywords = new HashMap<String, Integer>(60);
    char[] s;
    int pos;
    int prevPos;
    int intValue;
    String lastError;

    public IntRangeParser2(String str) {
        this.s = str != null ? str.toCharArray() : new char[]{};
        this.prevPos = 0;
        this.pos = 0;
        this.lastError = null;
    }

    private int parseNumber() {
        int n = this.s.length;
        boolean negative = false;
        while (this.pos < n && Character.isSpaceChar(this.s[this.pos])) {
            ++this.pos;
        }
        if (this.s[this.pos] == '+') {
            ++this.pos;
            while (this.pos < n && Character.isSpaceChar(this.s[this.pos])) {
                ++this.pos;
            }
        } else if (this.s[this.pos] == '-') {
            negative = true;
            ++this.pos;
            while (this.pos < n && Character.isSpaceChar(this.s[this.pos])) {
                ++this.pos;
            }
        }
        int minLimit = negative ? Integer.MIN_VALUE : -2147483647;
        int minLimit10 = minLimit / 10;
        int result = 0;
        int pos0 = this.pos;
        while (this.pos < n) {
            char ch = this.s[this.pos];
            if (ch != ',') {
                if (ch < '0' || ch > '9') {
                    if (this.pos != pos0) break;
                    this.error("Unexpected symbol in the number");
                    return 0x7FFFFFFE;
                }
                int digit = ch - 48;
                if (result < minLimit10) {
                    this.error(ERROR_OUT_RANGE);
                    return 0x7FFFFFFE;
                }
                if ((result *= 10) < minLimit + digit) {
                    this.error(ERROR_OUT_RANGE);
                    return 0x7FFFFFFE;
                }
                result -= digit;
            }
            ++this.pos;
        }
        while (this.pos < n && Character.isSpaceChar(this.s[this.pos])) {
            ++this.pos;
        }
        pos0 = this.pos;
        while (this.pos < n && Character.isLetterOrDigit(this.s[this.pos])) {
            ++this.pos;
        }
        if (this.pos != pos0 + 1) {
            this.pos = pos0;
        } else {
            switch (this.s[pos0]) {
                case 'K': {
                    if (result < minLimit / 1000) {
                        this.error(ERROR_OUT_RANGE);
                        return 0x7FFFFFFE;
                    }
                    result *= 1000;
                    break;
                }
                case 'M': {
                    if (result < minLimit / 1000000) {
                        this.error(ERROR_OUT_RANGE);
                        return 0x7FFFFFFE;
                    }
                    result *= 1000000;
                    break;
                }
                case 'B': {
                    if (result < minLimit / 1000000000) {
                        this.error(ERROR_OUT_RANGE);
                        return 0x7FFFFFFE;
                    }
                    result *= 1000000000;
                    break;
                }
                default: {
                    this.pos = pos0;
                }
            }
        }
        this.intValue = negative ? result : -result;
        return 1000006;
    }

    private int nextToken(boolean allowPlusMinusAsRange) {
        int n = this.s.length;
        this.prevPos = this.pos;
        while (this.pos < n && Character.isSpaceChar(this.s[this.pos])) {
            ++this.pos;
        }
        if (this.pos >= n) {
            return Integer.MAX_VALUE;
        }
        switch (this.s[this.pos]) {
            case '$': {
                ++this.pos;
                this.parseNumber();
                return 1000006;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseNumber();
            }
            case '-': {
                if (allowPlusMinusAsRange) {
                    ++this.pos;
                    return 1000000;
                }
                return this.parseNumber();
            }
            case '+': {
                return allowPlusMinusAsRange ? this.s[this.pos++] : this.parseNumber();
            }
            case '(': 
            case ')': 
            case '[': 
            case ']': {
                return this.s[this.pos++];
            }
            case '\u2026': {
                ++this.pos;
                return 1000001;
            }
            case ';': {
                ++this.pos;
                return 1000000;
            }
            case '.': {
                if (++this.pos < n && this.s[this.pos] == '.') {
                    if (++this.pos < n && this.s[this.pos] == '.') {
                        ++this.pos;
                        return 1000001;
                    }
                    return 1000000;
                }
                return 0x7FFFFFFE;
            }
            case '>': {
                if (this.pos + 1 < n && this.s[this.pos + 1] == '=') {
                    this.pos += 2;
                    return 1000003;
                }
                return this.s[this.pos++];
            }
            case '<': {
                if (this.pos + 1 < n && this.s[this.pos + 1] == '=') {
                    this.pos += 2;
                    return 1000002;
                }
                return this.s[this.pos++];
            }
        }
        int from = this.pos;
        while (this.pos < n && Character.isLetterOrDigit(this.s[this.pos])) {
            ++this.pos;
        }
        if (this.pos == from) {
            return 0x7FFFFFFE;
        }
        String id = new String(this.s, from, this.pos - from).toLowerCase();
        Integer keyword = keywords.get(id);
        if (keyword == null) {
            return 1000004;
        }
        this.intValue = keyword;
        return keyword < 1000 ? 1000006 : 1000005;
    }

    public IntRange parse() {
        int low = Integer.MIN_VALUE;
        int hi = Integer.MAX_VALUE;
        boolean atLeastOnePartParsed = false;
        block50: while (true) {
            int token = this.nextToken(false);
            switch (token) {
                case 0x7FFFFFFF: {
                    if (!atLeastOnePartParsed) {
                        return this.error("Integer range expected");
                    }
                    return this.newRange(low, hi);
                }
                case 60: 
                case 62: 
                case 1000002: 
                case 1000003: {
                    if (this.nextToken(false) != 1000006) {
                        return this.error("Integer number expected");
                    }
                    switch (token) {
                        case 62: {
                            low = Math.max(low, this.intValue + 1);
                            break;
                        }
                        case 60: {
                            hi = Math.min(hi, this.intValue - 1);
                            break;
                        }
                        case 1000003: {
                            low = Math.max(low, this.intValue);
                            break;
                        }
                        case 1000002: {
                            hi = Math.min(hi, this.intValue);
                        }
                    }
                    switch (this.nextToken(false)) {
                        case 0x7FFFFFFF: {
                            return this.newRange(low, hi);
                        }
                        case 1000005: {
                            if (this.intValue == 1000) break;
                        }
                        default: {
                            this.pos = this.prevPos;
                            break;
                        }
                    }
                    break;
                }
                case 1000006: {
                    int number = this.intValue;
                    block19 : switch (this.nextToken(true)) {
                        case 0x7FFFFFFF: {
                            return this.newRange(this.intValue, this.intValue);
                        }
                        case 43: {
                            low = Math.max(this.intValue, low);
                            switch (this.nextToken(false)) {
                                case 0x7FFFFFFF: {
                                    return this.newRange(low, hi);
                                }
                                case 1000005: {
                                    if (this.intValue != 1000) break;
                                    atLeastOnePartParsed = true;
                                    continue block50;
                                }
                            }
                            return this.error("Unexpected input");
                        }
                        case 62: {
                            hi = Math.min(this.intValue - 1, hi);
                            break;
                        }
                        case 60: {
                            low = Math.max(this.intValue + 1, low);
                            break;
                        }
                        case 1000003: {
                            low = Math.max(this.intValue, low);
                            break;
                        }
                        case 1000002: {
                            hi = Math.min(this.intValue, hi);
                            break;
                        }
                        case 1000000: {
                            if (this.nextToken(false) != 1000006) {
                                return this.error("Unexpected input");
                            }
                            low = Math.max(number, low);
                            hi = Math.min(this.intValue, hi);
                            break;
                        }
                        case 1000001: {
                            if (this.nextToken(false) != 1000006) {
                                return this.error("Expected number");
                            }
                            low = Math.max(number + 1, low);
                            hi = Math.min(this.intValue - 1, hi);
                            break;
                        }
                        case 1000005: {
                            switch (this.intValue) {
                                case 1000: {
                                    token = this.nextToken(false);
                                    if (token == Integer.MAX_VALUE) {
                                        return this.error("Unexpected end of input. Is it unfinished \"and more\"?");
                                    }
                                    if (token != 1000005 || this.intValue != 1002) {
                                        return this.error("Unexpected input. Is it unfinished \"and more\"?");
                                    }
                                    low = Math.max(low, number);
                                    break block19;
                                }
                                case 1003: {
                                    token = this.nextToken(false);
                                    if (token == Integer.MAX_VALUE) {
                                        return this.error("Unexpected end of input. Is it unfinished \"or less\"?");
                                    }
                                    if (token != 1000005 || this.intValue != 1001) {
                                        return this.error("Unexpected input. Is it unfinished \"or less\"?");
                                    }
                                    hi = Math.min(hi, number);
                                    break block19;
                                }
                            }
                            return this.error("Unexpected keyword");
                        }
                        default: {
                            return this.error("Unexpected input. Expected >,<,<=,>=, \"and more\", \"or less\"");
                        }
                    }
                    switch (this.nextToken(false)) {
                        case 0x7FFFFFFF: {
                            return this.newRange(low, hi);
                        }
                        case 1000005: {
                            if (this.intValue == 1000) break;
                        }
                        default: {
                            this.pos = this.prevPos;
                            break;
                        }
                    }
                    break;
                }
                case 1000005: {
                    switch (this.intValue) {
                        case 1002: {
                            token = this.nextToken(false);
                            if (token == Integer.MAX_VALUE) {
                                return this.error("Unexpected end of input. Should it be \"more than <NUMBER>\"?");
                            }
                            if (token != 1000005 || this.intValue != 1004) {
                                return this.error("Unexpected input. Should it be \"more than <NUMBER>\"?");
                            }
                            if (this.nextToken(false) != 1000006) {
                                return this.error(ERROR_NOT_NUMBER);
                            }
                            low = Math.max(low, this.intValue + 1);
                            break;
                        }
                        case 1001: {
                            token = this.nextToken(false);
                            if (token == Integer.MAX_VALUE) {
                                return this.error("Unexpected end of input. Should it be \"less than <NUMBER>\"?");
                            }
                            if (token != 1000005 || this.intValue != 1004) {
                                return this.error("Unexpected input. Should it be \"less than <NUMBER>\"?");
                            }
                            if (this.nextToken(false) != 1000006) {
                                return this.error(ERROR_NOT_NUMBER);
                            }
                            hi = Math.min(hi, this.intValue - 1);
                            break;
                        }
                        default: {
                            return this.error("Unexpected keyword");
                        }
                    }
                    if (this.nextToken(false) == 1000005 && this.intValue == 1000) break;
                    this.pos = this.prevPos;
                    break;
                }
                case 40: 
                case 91: {
                    int c;
                    if (this.nextToken(false) != 1000006) {
                        return this.error(ERROR_NOT_NUMBER);
                    }
                    int n = c = token == 91 ? this.intValue : this.intValue + 1;
                    if (this.nextToken(true) != 1000000) {
                        return this.error("Range delimiter \";\",\"-\", \"..\", expected");
                    }
                    if (this.nextToken(false) != 1000006) {
                        return this.error(ERROR_NOT_NUMBER);
                    }
                    int d = this.intValue;
                    switch (this.nextToken(false)) {
                        case 41: {
                            --d;
                            break;
                        }
                        case 93: {
                            break;
                        }
                        default: {
                            return this.error("\")\" or \"]\" expected");
                        }
                    }
                    return this.newRange(Math.max(low, c), Math.min(hi, d));
                }
                case 0x7FFFFFFE: {
                    return null;
                }
                case 1000004: {
                    return this.error("Unexpected identifier");
                }
                default: {
                    return this.error("Unexpected input");
                }
            }
            atLeastOnePartParsed = true;
        }
    }

    private IntRange error(String errorMessage) {
        this.lastError = errorMessage;
        return null;
    }

    private IntRange newRange(int low, int hi) {
        if (low > hi) {
            return this.error("The upper bound '" + hi + "' must be more or equal than the lower bound '" + low + "'.");
        }
        return new IntRange(low, hi);
    }

    public static IntRange parse(String str) {
        return new IntRangeParser2(str).parse();
    }

    static {
        keywords.put("and", 1000);
        keywords.put("less", 1001);
        keywords.put("more", 1002);
        keywords.put("or", 1003);
        keywords.put("than", 1004);
        String[] NUMBERS = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty"};
        for (int i = 0; i < NUMBERS.length; ++i) {
            keywords.put(NUMBERS[i], i);
        }
    }
}

