/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.message.OpenLMessagesUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.util.PathTool;
import org.openl.util.StringTool;

public class IncludeSearcher {
    private static final String INCLUDE = "include/";
    private String searchPath;
    private IConfigurableResourceContext ucxt;

    public IncludeSearcher(IConfigurableResourceContext ucxt, String searchPath) {
        this.ucxt = ucxt;
        this.searchPath = searchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IOpenSourceCodeModule findInclude(String include) {
        if (this.searchPath == null) {
            this.searchPath = INCLUDE;
        }
        String[] path = StringTool.tokenize((String)this.searchPath, (String)";");
        for (int i = 0; i < path.length; ++i) {
            String p = PathTool.mergePath((String)path[i], (String)include);
            URL url = this.ucxt.findClassPathResource(p);
            if (url != null) {
                return new URLSourceCodeModule(url);
            }
            File f = this.ucxt.findFileSystemResource(p);
            if (f != null) {
                return new FileSourceCodeModule(f, null);
            }
            String u2 = path[i] + include;
            URL xurl = new URL(u2);
            InputStream is = null;
            try {
                is = xurl.openStream();
                if (is == null) return new URLSourceCodeModule(xurl);
            }
            catch (IOException iox) {
                IOpenSourceCodeModule iOpenSourceCodeModule;
                try {
                    iOpenSourceCodeModule = null;
                    if (is == null) return iOpenSourceCodeModule;
                }
                catch (Throwable throwable) {
                    try {
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        OpenLMessagesUtils.addWarn((String)String.format("Cannot find '%s' ()", include, t.getMessage()));
                        continue;
                    }
                }
                is.close();
                return iOpenSourceCodeModule;
            }
            is.close();
            return new URLSourceCodeModule(xurl);
        }
        return null;
    }
}

