/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.openl.rules.calc.CellsHeaderExtractor;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.SpreadsheetHeaderNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;

public class SpreadsheetNodeSorter {
    private static boolean check(TableSyntaxNode table1, TableSyntaxNode table2) {
        if (SpreadsheetNodeSorter.isSpreadsheet(table1) && SpreadsheetNodeSorter.isSpreadsheet(table2)) {
            CellsHeaderExtractor extractor1 = SpreadsheetNodeSorter.extractNames(table1);
            String methodName2 = SpreadsheetNodeSorter.getMethodName(table2);
            if (StringUtils.isNotBlank((CharSequence)methodName2) && extractor1.getDependentSpreadsheetTypes().contains(methodName2)) {
                return true;
            }
        }
        return false;
    }

    public static TableSyntaxNode[] sort(TableSyntaxNode[] tableSyntaxNodes) {
        int i;
        TableSyntaxNode[] result = new TableSyntaxNode[tableSyntaxNodes.length];
        boolean[][] matrix = new boolean[tableSyntaxNodes.length][tableSyntaxNodes.length];
        int[] c = new int[tableSyntaxNodes.length];
        for (int i2 = 0; i2 < tableSyntaxNodes.length; ++i2) {
            for (int j = 0; j < tableSyntaxNodes.length; ++j) {
                if (i2 == j || !SpreadsheetNodeSorter.check(tableSyntaxNodes[i2], tableSyntaxNodes[j])) continue;
                matrix[j][i2] = true;
                int n = i2;
                c[n] = c[n] + 1;
            }
        }
        int n = 0;
        LinkedList<Integer> q = new LinkedList<Integer>();
        for (i = 0; i < tableSyntaxNodes.length; ++i) {
            if (c[i] != 0) continue;
            q.add(i);
        }
        while (!q.isEmpty()) {
            int t = (Integer)q.poll();
            result[n++] = tableSyntaxNodes[t];
            for (int i3 = 0; i3 < tableSyntaxNodes.length; ++i3) {
                if (!matrix[t][i3]) continue;
                int n2 = i3;
                c[n2] = c[n2] - 1;
                if (c[i3] != 0) continue;
                q.add(i3);
            }
        }
        if (n < tableSyntaxNodes.length) {
            for (i = 0; i < tableSyntaxNodes.length; ++i) {
                if (c[i] <= 0) continue;
                result[n++] = tableSyntaxNodes[i];
            }
        }
        return result;
    }

    private static String getMethodName(TableSyntaxNode table) {
        String methodName = "";
        String[] tokens = SpreadsheetNodeSorter.getSignature(table).split(" ");
        if (tokens != null && tokens.length > 2) {
            int bracketIndex = tokens[2].indexOf("(");
            methodName = bracketIndex >= 0 ? tokens[2].substring(0, bracketIndex) : tokens[2];
        }
        return methodName;
    }

    private static String getSignature(TableSyntaxNode table) {
        return table.getHeader().getHeaderToken().getModule().getCode();
    }

    private static boolean isSpreadsheet(TableSyntaxNode o1) {
        return XlsNodeTypes.XLS_SPREADSHEET.equals((Object)o1.getNodeType());
    }

    private static CellsHeaderExtractor extractNames(TableSyntaxNode tableSyntaxNode) {
        CellsHeaderExtractor extractor = null;
        extractor = ((SpreadsheetHeaderNode)tableSyntaxNode.getHeader()).getCellHeadersExtractor();
        if (extractor == null) {
            extractor = new CellsHeaderExtractor(SpreadsheetNodeSorter.getSignature(tableSyntaxNode), (ILogicalTable)((ILogicalTable)tableSyntaxNode.getTableBody().getRow(0)).getColumns(1), (ILogicalTable)((ILogicalTable)tableSyntaxNode.getTableBody().getColumn(0)).getRows(1));
            extractor.extract();
            ((SpreadsheetHeaderNode)tableSyntaxNode.getHeader()).setCellHeadersExtractor(extractor);
        }
        return extractor;
    }
}

