/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.CompiledOpenClass;
import org.openl.IOpenBinder;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.INameSpacedMethodFactory;
import org.openl.binding.INameSpacedTypeFactory;
import org.openl.binding.INameSpacedVarFactory;
import org.openl.binding.INodeBinderFactory;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.BoundCode;
import org.openl.binding.impl.module.ModuleNode;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.conf.IExecutable;
import org.openl.conf.IOpenLBuilder;
import org.openl.conf.IUserContext;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.OpenLBuilderImpl;
import org.openl.dependency.CompiledDependency;
import org.openl.engine.OpenLSystemProperties;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.meta.IVocabulary;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.calc.SpreadsheetNodeBinder;
import org.openl.rules.cmatch.ColumnMatchNodeBinder;
import org.openl.rules.data.DataBase;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.data.IDataBase;
import org.openl.rules.datatype.binding.DatatypeNodeBinder;
import org.openl.rules.datatype.binding.DatatypesSorter;
import org.openl.rules.dt.DecisionTableNodeBinder;
import org.openl.rules.lang.xls.PrebindOpenMethod;
import org.openl.rules.lang.xls.SpreadsheetNodeSorter;
import org.openl.rules.lang.xls.SyntaxNodeConvertor;
import org.openl.rules.lang.xls.TestAndMethodTableNodeComparator;
import org.openl.rules.lang.xls.XlsHelper;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.binding.AExecutableNodeBinder;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.OpenlSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.method.table.MethodTableNodeBinder;
import org.openl.rules.property.PropertyTableBinder;
import org.openl.rules.table.properties.PropertiesLoader;
import org.openl.rules.tbasic.AlgorithmNodeBinder;
import org.openl.rules.testmethod.TestMethodNodeBinder;
import org.openl.rules.validation.properties.dimentional.DispatcherTablesBuilder;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.util.ASelector;
import org.openl.util.AStringConvertor;
import org.openl.util.ISelector;
import org.openl.util.RuntimeExceptionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsBinder
implements IOpenBinder {
    private final Logger log = LoggerFactory.getLogger(XlsBinder.class);
    private static Map<String, AXlsTableBinder> binderFactory;
    public static final String DEFAULT_OPENL_NAME = "org.openl.rules.java";
    private static final String[][] BINDERS;
    private IUserContext userContext;

    public static synchronized Map<String, AXlsTableBinder> getBinderFactory() {
        if (binderFactory == null) {
            binderFactory = new HashMap<String, AXlsTableBinder>();
            for (int i = 0; i < BINDERS.length; ++i) {
                try {
                    binderFactory.put(BINDERS[i][0], (AXlsTableBinder)((Object)Class.forName(BINDERS[i][1]).newInstance()));
                    continue;
                }
                catch (Exception ex) {
                    throw RuntimeExceptionWrapper.wrap((Throwable)ex);
                }
            }
        }
        return binderFactory;
    }

    public XlsBinder(IUserContext userContext) {
        this.userContext = userContext;
    }

    public ICastFactory getCastFactory() {
        return null;
    }

    public INameSpacedMethodFactory getMethodFactory() {
        return null;
    }

    public INodeBinderFactory getNodeBinderFactory() {
        return null;
    }

    public INameSpacedTypeFactory getTypeFactory() {
        return null;
    }

    public INameSpacedVarFactory getVarFactory() {
        return null;
    }

    public IBindingContext makeBindingContext() {
        throw new UnsupportedOperationException("XlsBinder is top level Binder");
    }

    public IBoundCode bind(IParsedCode parsedCode) {
        return this.bind(parsedCode, null);
    }

    public IBoundCode bind(IParsedCode parsedCode, IBindingContextDelegator bindingContextDelegator) {
        XlsModuleSyntaxNode moduleNode = (XlsModuleSyntaxNode)parsedCode.getTopNode();
        OpenL openl = null;
        try {
            openl = this.makeOpenL(moduleNode);
        }
        catch (OpenConfigurationException ex) {
            OpenlSyntaxNode syntaxNode = moduleNode.getOpenlNode();
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Error Creating OpenL", (Throwable)ex, (ISyntaxNode)syntaxNode);
            BindHelper.processError((SyntaxNodeException)error);
            return BindHelper.makeInvalidCode((IParsedCode)parsedCode, (ISyntaxNode)syntaxNode, (SyntaxNodeException[])new SyntaxNodeException[]{error});
        }
        IOpenBinder openlBinder = openl.getBinder();
        IBindingContext bindingContext = openlBinder.makeBindingContext();
        bindingContext = BindHelper.delegateContext((IBindingContext)bindingContext, (IBindingContextDelegator)bindingContextDelegator);
        if (parsedCode.getExternalParams() != null) {
            bindingContext.setExternalParams(parsedCode.getExternalParams());
        }
        IBoundNode topNode = null;
        topNode = !parsedCode.getCompiledDependencies().isEmpty() ? this.bindWithDependencies(moduleNode, openl, bindingContext, parsedCode.getCompiledDependencies()) : this.bind(moduleNode, openl, bindingContext);
        return new BoundCode(parsedCode, topNode, bindingContext.getErrors(), 0);
    }

    private IBoundNode bindWithDependencies(XlsModuleSyntaxNode moduleNode, OpenL openl, IBindingContext bindingContext, Set<CompiledDependency> moduleDependencies) {
        XlsModuleOpenClass moduleOpenClass = this.createModuleOpenClass(moduleNode, openl, this.getModuleDatabase(), moduleDependencies, bindingContext);
        RulesModuleBindingContext moduleContext = this.populateBindingContextWithDependencies(moduleNode, bindingContext, moduleDependencies, moduleOpenClass);
        return this.processBinding(moduleNode, openl, moduleContext, moduleOpenClass, bindingContext);
    }

    protected IDataBase getModuleDatabase() {
        return new DataBase();
    }

    private RulesModuleBindingContext populateBindingContextWithDependencies(XlsModuleSyntaxNode moduleNode, IBindingContext bindingContext, Set<CompiledDependency> moduleDependencies, XlsModuleOpenClass moduleOpenClass) {
        RulesModuleBindingContext moduleContext = this.createRulesBindingContext(bindingContext, moduleOpenClass);
        for (CompiledDependency compiledDependency : moduleDependencies) {
            CompiledOpenClass compiledOpenClass = compiledDependency.getCompiledOpenClass();
            try {
                moduleContext.addTypes(this.filterDependencyTypes(compiledOpenClass.getTypes(), moduleContext.getInternalTypes()));
            }
            catch (Exception ex) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Can`t add datatype from dependency", (Throwable)ex, (ISyntaxNode)moduleNode);
                BindHelper.processError((SyntaxNodeException)error);
            }
        }
        return moduleContext;
    }

    private Map<String, IOpenClass> filterDependencyTypes(Map<String, IOpenClass> dependencyDatatypes, Map<String, IOpenClass> contextTypes) {
        HashMap<String, IOpenClass> filteredDependencyDatatypes = new HashMap<String, IOpenClass>();
        for (String key : dependencyDatatypes.keySet()) {
            IOpenClass contextDatatype;
            IOpenClass dependencyDatatype = dependencyDatatypes.get(key);
            if (dependencyDatatype.equals(contextDatatype = contextTypes.get(key))) continue;
            filteredDependencyDatatypes.put(key, dependencyDatatype);
        }
        return filteredDependencyDatatypes;
    }

    public IBoundNode bind(XlsModuleSyntaxNode moduleNode, OpenL openl, IBindingContext bindingContext) {
        XlsModuleOpenClass moduleOpenClass = this.createModuleOpenClass(moduleNode, openl, this.getModuleDatabase(), null, bindingContext);
        RulesModuleBindingContext moduleContext = this.createRulesBindingContext(bindingContext, moduleOpenClass);
        return this.processBinding(moduleNode, openl, moduleContext, moduleOpenClass, bindingContext);
    }

    private IBoundNode processBinding(XlsModuleSyntaxNode moduleNode, OpenL openl, RulesModuleBindingContext moduleContext, XlsModuleOpenClass moduleOpenClass, IBindingContext bindingContext) {
        IVocabulary vocabulary = this.makeVocabulary(moduleNode);
        if (vocabulary != null) {
            this.processVocabulary(vocabulary, moduleContext);
        }
        ASelector.StringValueSelector<ISyntaxNode> propertiesSelector = this.getSelector(XlsNodeTypes.XLS_PROPERTIES);
        TableSyntaxNode[] propertiesNodes = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)propertiesSelector);
        this.bindInternal(moduleNode, moduleOpenClass, propertiesNodes, openl, moduleContext);
        this.bindPropertiesForAllTables(moduleNode, moduleOpenClass, openl, moduleContext);
        ASelector.StringValueSelector<ISyntaxNode> dataTypeSelector = this.getSelector(XlsNodeTypes.XLS_DATATYPE);
        TableSyntaxNode[] datatypeNodes = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)dataTypeSelector);
        TableSyntaxNode[] processedDatatypeNodes = new DatatypesSorter().sort(datatypeNodes, (IBindingContext)moduleContext);
        this.bindInternal(moduleNode, moduleOpenClass, processedDatatypeNodes, openl, moduleContext);
        ISelector notPropertiesAndNotDatatypeSelector = propertiesSelector.not().and(dataTypeSelector.not());
        IBoundNode topNode = null;
        if (OpenLSystemProperties.isCustomSpreadsheetType(moduleContext.getExternalParams())) {
            topNode = this.bindInternalWithCustomSpreadsheetTypes(moduleNode, openl, moduleContext, moduleOpenClass, (ISelector<ISyntaxNode>)notPropertiesAndNotDatatypeSelector);
        } else {
            TableSyntaxNode[] otherNodes = this.selectAndSortNodes(moduleNode, (ISelector<ISyntaxNode>)notPropertiesAndNotDatatypeSelector, new TestAndMethodTableNodeComparator());
            topNode = this.bindInternal(moduleNode, moduleOpenClass, otherNodes, openl, moduleContext);
        }
        DispatcherTablesBuilder dispTableBuilder = new DispatcherTablesBuilder((XlsModuleOpenClass)topNode.getType(), moduleContext);
        dispTableBuilder.build();
        this.processErrors(moduleOpenClass.getErrors(), bindingContext);
        return topNode;
    }

    private IBoundNode bindInternalWithCustomSpreadsheetTypes(XlsModuleSyntaxNode moduleNode, OpenL openl, RulesModuleBindingContext moduleContext, XlsModuleOpenClass moduleOpenClass, ISelector<ISyntaxNode> notPropertiesAndNotDatatypeSelector) {
        ASelector.StringValueSelector<ISyntaxNode> spreadsheetSelector = this.getSelector(XlsNodeTypes.XLS_SPREADSHEET);
        ASelector.StringValueSelector<ISyntaxNode> testMethodSelector = this.getSelector(XlsNodeTypes.XLS_TEST_METHOD);
        ASelector.StringValueSelector<ISyntaxNode> runMethodSelector = this.getSelector(XlsNodeTypes.XLS_RUN_METHOD);
        ISelector commonTablesSelector = notPropertiesAndNotDatatypeSelector.and(spreadsheetSelector.not().and(testMethodSelector.not().and(runMethodSelector.not())));
        TableSyntaxNode[] commonTables = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)commonTablesSelector);
        TableSyntaxNode[] spreadsheets = this.selectAndSortSpreadsheetNodes(moduleNode, (ISelector<ISyntaxNode>)spreadsheetSelector);
        TableSyntaxNode[] commonAndSpreadsheetTables = (TableSyntaxNode[])ArrayUtils.addAll((Object[])commonTables, (Object[])spreadsheets);
        this.bindInternal(moduleNode, moduleOpenClass, commonAndSpreadsheetTables, openl, moduleContext);
        TableSyntaxNode[] testsAndRunTables = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)testMethodSelector.or(runMethodSelector));
        return this.bindInternal(moduleNode, moduleOpenClass, testsAndRunTables, openl, moduleContext);
    }

    private ASelector.StringValueSelector<ISyntaxNode> getSelector(XlsNodeTypes selectorValue) {
        return this.getSelector(selectorValue.toString());
    }

    private ASelector.StringValueSelector<ISyntaxNode> getSelector(String selectorValue) {
        return new ASelector.StringValueSelector(selectorValue, (AStringConvertor)new SyntaxNodeConvertor());
    }

    private RulesModuleBindingContext createRulesBindingContext(IBindingContext bindingContext, XlsModuleOpenClass moduleOpenClass) {
        return new RulesModuleBindingContext(bindingContext, moduleOpenClass);
    }

    protected XlsModuleOpenClass createModuleOpenClass(XlsModuleSyntaxNode moduleNode, OpenL openl, IDataBase dbase, Set<CompiledDependency> moduleDependencies, IBindingContext bindingContext) {
        return new XlsModuleOpenClass(XlsHelper.getModuleName(moduleNode), new XlsMetaInfo(moduleNode), openl, dbase, moduleDependencies, Thread.currentThread().getContextClassLoader(), OpenLSystemProperties.isDTDispatchingMode(bindingContext.getExternalParams()), OpenLSystemProperties.isDispatchingValidationEnabled(bindingContext.getExternalParams()));
    }

    private void bindPropertiesForAllTables(XlsModuleSyntaxNode moduleNode, XlsModuleOpenClass module, OpenL openl, RulesModuleBindingContext bindingContext) {
        ASelector.StringValueSelector<ISyntaxNode> propertiesSelector = this.getSelector(XlsNodeTypes.XLS_PROPERTIES);
        ASelector.StringValueSelector<ISyntaxNode> otherNodesSelector = this.getSelector(XlsNodeTypes.XLS_OTHER);
        ISelector notPropertiesAndNotOtherSelector = propertiesSelector.not().and(otherNodesSelector.not());
        TableSyntaxNode[] tableSyntaxNodes = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)notPropertiesAndNotOtherSelector);
        PropertiesLoader propLoader = new PropertiesLoader(openl, bindingContext, module);
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            try {
                propLoader.loadProperties(tsn);
            }
            catch (SyntaxNodeException error) {
                this.processError(error, tsn, bindingContext);
            }
            catch (CompositeSyntaxNodeException ex) {
                for (SyntaxNodeException error : ex.getErrors()) {
                    this.processError(error, tsn, bindingContext);
                }
            }
            catch (Throwable t) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tsn);
                this.processError(error, tsn, bindingContext);
            }
        }
    }

    private void processVocabulary(IVocabulary vocabulary, RulesModuleBindingContext moduleContext) {
        IOpenClass[] types = null;
        try {
            types = vocabulary.getVocabularyTypes();
        }
        catch (SyntaxNodeException error) {
            BindHelper.processError((SyntaxNodeException)error, (IBindingContext)moduleContext);
        }
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                try {
                    moduleContext.addType("org.openl.this", types[i]);
                    continue;
                }
                catch (Throwable t) {
                    BindHelper.processError(null, (Throwable)t, (IBindingContext)moduleContext);
                }
            }
        }
    }

    private OpenL makeOpenL(XlsModuleSyntaxNode moduleNode) {
        String openlName = this.getOpenLName(moduleNode.getOpenlNode());
        Collection<String> allImports = moduleNode.getImports();
        if (allImports == null) {
            return OpenL.getInstance((String)openlName, (IUserContext)this.userContext);
        }
        OpenLBuilderImpl builder = new OpenLBuilderImpl();
        builder.setExtendsCategory(openlName);
        String category = openlName + "::" + moduleNode.getModule().getUri(0);
        builder.setCategory(category);
        builder.setImports(allImports);
        builder.setContexts(null, this.userContext);
        builder.setInheritExtendedConfigurationLoader(true);
        return OpenL.getInstance((String)category, (IUserContext)this.userContext, (IOpenLBuilder)builder);
    }

    private IVocabulary makeVocabulary(XlsModuleSyntaxNode moduleNode) {
        final IdentifierNode vocabularyNode = moduleNode.getVocabularyNode();
        if (vocabularyNode == null) {
            return null;
        }
        final ClassLoader userClassLoader = this.userContext.getUserClassLoader();
        Thread.currentThread().setContextClassLoader(userClassLoader);
        IVocabulary vocabulary = (IVocabulary)this.userContext.execute(new IExecutable(){

            public Object execute() {
                String vocabularyClassName = vocabularyNode.getIdentifier();
                try {
                    Class<?> vClass = userClassLoader.loadClass(vocabularyClassName);
                    return vClass.newInstance();
                }
                catch (Throwable t) {
                    String message = String.format("Vocabulary type '%s' cannot be loaded", vocabularyClassName);
                    BindHelper.processError((String)message, (ISyntaxNode)vocabularyNode, (Throwable)t);
                    return null;
                }
            }
        });
        return vocabulary;
    }

    private IMemberBoundNode preBindXlsNode(ISyntaxNode syntaxNode, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass moduleOpenClass) throws Exception {
        String tableSyntaxNodeType = syntaxNode.getType();
        AXlsTableBinder binder = this.findBinder(tableSyntaxNodeType);
        if (binder == null) {
            this.log.debug("Unknown table type '{}'", (Object)tableSyntaxNodeType);
            return null;
        }
        TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)syntaxNode;
        return binder.preBind(tableSyntaxNode, openl, (IBindingContext)bindingContext, moduleOpenClass);
    }

    protected AXlsTableBinder findBinder(String tableSyntaxNodeType) {
        return XlsBinder.getBinderFactory().get(tableSyntaxNodeType);
    }

    protected String getDefaultOpenLName() {
        return DEFAULT_OPENL_NAME;
    }

    private String getOpenLName(OpenlSyntaxNode osn) {
        return osn == null ? this.getDefaultOpenLName() : osn.getOpenlName();
    }

    private TableSyntaxNode[] selectNodes(XlsModuleSyntaxNode moduleSyntaxNode, ISelector<ISyntaxNode> childSelector) {
        return this.selectAndSortNodes(moduleSyntaxNode, childSelector, null);
    }

    private TableSyntaxNode[] selectAndSortNodes(XlsModuleSyntaxNode moduleSyntaxNode, ISelector<ISyntaxNode> childSelector, Comparator<TableSyntaxNode> nodesComparator) {
        ArrayList<TableSyntaxNode> childSyntaxNodes = new ArrayList<TableSyntaxNode>();
        for (TableSyntaxNode tsn : moduleSyntaxNode.getXlsTableSyntaxNodes()) {
            if (childSelector != null && !childSelector.select((Object)tsn)) continue;
            childSyntaxNodes.add(tsn);
        }
        TableSyntaxNode[] tableSyntaxNodes = childSyntaxNodes.toArray(new TableSyntaxNode[childSyntaxNodes.size()]);
        if (nodesComparator != null) {
            try {
                Arrays.sort(tableSyntaxNodes, nodesComparator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tableSyntaxNodes;
    }

    private TableSyntaxNode[] selectAndSortSpreadsheetNodes(XlsModuleSyntaxNode moduleSyntaxNode, ISelector<ISyntaxNode> childSelector) {
        ArrayList<TableSyntaxNode> childSyntaxNodes = new ArrayList<TableSyntaxNode>();
        for (TableSyntaxNode tsn : moduleSyntaxNode.getXlsTableSyntaxNodes()) {
            if (childSelector != null && !childSelector.select((Object)tsn)) continue;
            childSyntaxNodes.add(tsn);
        }
        TableSyntaxNode[] tableSyntaxNodes = childSyntaxNodes.toArray(new TableSyntaxNode[childSyntaxNodes.size()]);
        return SpreadsheetNodeSorter.sort(tableSyntaxNodes);
    }

    private boolean isExecutableTableSyntaxNode(TableSyntaxNode tableSyntaxNode) {
        return tableSyntaxNode.getNodeType() == XlsNodeTypes.XLS_DT || tableSyntaxNode.getNodeType() == XlsNodeTypes.XLS_TBASIC || tableSyntaxNode.getNodeType() == XlsNodeTypes.XLS_METHOD || tableSyntaxNode.getNodeType() == XlsNodeTypes.XLS_COLUMN_MATCH || tableSyntaxNode.getNodeType() == XlsNodeTypes.XLS_SPREADSHEET;
    }

    protected IBoundNode bindInternal(XlsModuleSyntaxNode moduleSyntaxNode, XlsModuleOpenClass module, TableSyntaxNode[] tableSyntaxNodes, OpenL openl, RulesModuleBindingContext moduleContext) {
        SyntaxNodeException error;
        IMemberBoundNode child;
        int i;
        IMemberBoundNode[] children = new IMemberBoundNode[tableSyntaxNodes.length];
        for (i = 0; i < tableSyntaxNodes.length; ++i) {
            if (this.isExecutableTableSyntaxNode(tableSyntaxNodes[i])) {
                AExecutableNodeBinder aExecutableNodeBinder = (AExecutableNodeBinder)XlsBinder.getBinderFactory().get(tableSyntaxNodes[i].getType());
                try {
                    OpenMethodHeader openMethodHeader = aExecutableNodeBinder.createHeader(tableSyntaxNodes[i], openl, (IBindingContext)moduleContext);
                    if (moduleContext.isExecutionMode()) {
                        moduleContext.addPrebindMethod(new PrebindOpenMethod((IOpenMethodHeader)openMethodHeader, null));
                        continue;
                    }
                    moduleContext.addPrebindMethod(new PrebindOpenMethod((IOpenMethodHeader)openMethodHeader, tableSyntaxNodes[i]));
                }
                catch (Exception openMethodHeader) {}
                continue;
            }
            children[i] = child = this.beginBind(tableSyntaxNodes[i], module, openl, moduleContext);
            if (child == null) continue;
            try {
                child.addTo((ModuleOpenClass)module);
                continue;
            }
            catch (OpenlNotCheckedException e) {
                error = SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)tableSyntaxNodes[i]);
                this.processError(error, tableSyntaxNodes[i], moduleContext);
            }
        }
        for (i = 0; i < children.length; ++i) {
            if (!this.isExecutableTableSyntaxNode(tableSyntaxNodes[i])) continue;
            children[i] = child = this.beginBind(tableSyntaxNodes[i], module, openl, moduleContext);
            if (child == null) continue;
            try {
                child.addTo((ModuleOpenClass)module);
                continue;
            }
            catch (OpenlNotCheckedException e) {
                error = SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)tableSyntaxNodes[i]);
                this.processError(error, tableSyntaxNodes[i], moduleContext);
            }
        }
        for (i = 0; i < children.length; ++i) {
            if (children[i] == null) continue;
            this.finilizeBind(children[i], tableSyntaxNodes[i], moduleContext);
        }
        if (moduleContext.isExecutionMode()) {
            this.removeDebugInformation(children, tableSyntaxNodes, moduleContext);
        }
        moduleContext.clearPrebindMethods();
        return new ModuleNode((ISyntaxNode)moduleSyntaxNode, (IOpenClass)moduleContext.getModule());
    }

    protected void finilizeBind(IMemberBoundNode memberBoundNode, TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext moduleContext) {
        try {
            memberBoundNode.finalizeBind((IBindingContext)moduleContext);
        }
        catch (SyntaxNodeException error) {
            this.processError(error, tableSyntaxNode, moduleContext);
        }
        catch (CompositeSyntaxNodeException ex) {
            if (ex.getErrors() != null) {
                for (SyntaxNodeException error : ex.getErrors()) {
                    this.processError(error, tableSyntaxNode, moduleContext);
                }
            }
        }
        catch (Throwable t) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNode);
            this.processError(error, tableSyntaxNode, moduleContext);
        }
    }

    protected void removeDebugInformation(IMemberBoundNode[] boundNodes, TableSyntaxNode[] tableSyntaxNodes, RulesModuleBindingContext moduleContext) {
        for (int i = 0; i < boundNodes.length; ++i) {
            if (boundNodes[i] == null) continue;
            try {
                boundNodes[i].removeDebugInformation((IBindingContext)moduleContext);
                continue;
            }
            catch (SyntaxNodeException error) {
                this.processError(error, tableSyntaxNodes[i], moduleContext);
                continue;
            }
            catch (CompositeSyntaxNodeException ex) {
                for (SyntaxNodeException error : ex.getErrors()) {
                    this.processError(error, tableSyntaxNodes[i], moduleContext);
                }
                continue;
            }
            catch (Throwable t) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNodes[i]);
                this.processError(error, tableSyntaxNodes[i], moduleContext);
            }
        }
    }

    protected IMemberBoundNode beginBind(TableSyntaxNode tableSyntaxNode, XlsModuleOpenClass module, OpenL openl, RulesModuleBindingContext moduleContext) {
        try {
            return this.preBindXlsNode((ISyntaxNode)tableSyntaxNode, openl, moduleContext, module);
        }
        catch (SyntaxNodeException error) {
            this.processError(error, tableSyntaxNode, moduleContext);
            return null;
        }
        catch (CompositeSyntaxNodeException ex) {
            for (SyntaxNodeException error : ex.getErrors()) {
                this.processError(error, tableSyntaxNode, moduleContext);
            }
            return null;
        }
        catch (Throwable t) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNode);
            this.processError(error, tableSyntaxNode, moduleContext);
            return null;
        }
    }

    protected void processError(SyntaxNodeException error, TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext moduleContext) {
        tableSyntaxNode.addError(error);
        BindHelper.processError((SyntaxNodeException)error, (IBindingContext)moduleContext);
    }

    protected void processErrors(List<Throwable> errors, IBindingContext bindingContext) {
        if (errors != null) {
            for (Throwable error : errors) {
                if (error instanceof SyntaxNodeException) {
                    BindHelper.processError((SyntaxNodeException)((SyntaxNodeException)error), (IBindingContext)bindingContext);
                    continue;
                }
                if (error instanceof CompositeSyntaxNodeException) {
                    BindHelper.processError((CompositeSyntaxNodeException)((CompositeSyntaxNodeException)error), (IBindingContext)bindingContext);
                    continue;
                }
                BindHelper.processError((Throwable)error, null, (IBindingContext)bindingContext);
            }
        }
    }

    static {
        BINDERS = new String[][]{{XlsNodeTypes.XLS_DATA.toString(), DataNodeBinder.class.getName()}, {XlsNodeTypes.XLS_DATATYPE.toString(), DatatypeNodeBinder.class.getName()}, {XlsNodeTypes.XLS_DT.toString(), DecisionTableNodeBinder.class.getName()}, {XlsNodeTypes.XLS_SPREADSHEET.toString(), SpreadsheetNodeBinder.class.getName()}, {XlsNodeTypes.XLS_METHOD.toString(), MethodTableNodeBinder.class.getName()}, {XlsNodeTypes.XLS_TEST_METHOD.toString(), TestMethodNodeBinder.class.getName()}, {XlsNodeTypes.XLS_RUN_METHOD.toString(), TestMethodNodeBinder.class.getName()}, {XlsNodeTypes.XLS_TBASIC.toString(), AlgorithmNodeBinder.class.getName()}, {XlsNodeTypes.XLS_COLUMN_MATCH.toString(), ColumnMatchNodeBinder.class.getName()}, {XlsNodeTypes.XLS_PROPERTIES.toString(), PropertyTableBinder.class.getName()}};
    }
}

