/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IUserContext;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.IncludeSearcher;
import org.openl.rules.lang.xls.TablePart;
import org.openl.rules.lang.xls.TablePartProcessor;
import org.openl.rules.lang.xls.XlsHelper;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.syntax.OpenlSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.WorkbookSyntaxNode;
import org.openl.rules.lang.xls.syntax.WorksheetSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.utils.ParserUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.Dependency;
import org.openl.syntax.code.DependencyType;
import org.openl.syntax.code.IDependency;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.code.impl.ParsedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.util.PathTool;
import org.openl.util.StringTool;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsLoader {
    private final Logger log = LoggerFactory.getLogger(XlsLoader.class);
    private Collection<String> imports = new HashSet<String>();
    private IncludeSearcher includeSeeker;
    private OpenlSyntaxNode openl;
    private IdentifierNode vocabulary;
    private List<SyntaxNodeException> errors = new ArrayList<SyntaxNodeException>();
    private HashSet<String> preprocessedWorkBooks = new HashSet();
    private List<WorkbookSyntaxNode> workbookNodes = new ArrayList<WorkbookSyntaxNode>();
    private List<IDependency> dependencies = new ArrayList<IDependency>();

    @Deprecated
    public XlsLoader(IConfigurableResourceContext ucxt, String searchPath) {
        this.includeSeeker = new IncludeSearcher(ucxt, searchPath);
    }

    public XlsLoader(IncludeSearcher includeSeeker, IUserContext userContext) {
        this.includeSeeker = includeSeeker;
    }

    public void addError(SyntaxNodeException error) {
        this.errors.add(error);
    }

    public Set<String> getPreprocessedWorkBooks() {
        return this.preprocessedWorkBooks;
    }

    public IParsedCode parse(IOpenSourceCodeModule source) {
        this.preprocessWorkbook(source);
        this.addInnerImports();
        WorkbookSyntaxNode[] workbooksArray = this.workbookNodes.toArray(new WorkbookSyntaxNode[this.workbookNodes.size()]);
        XlsModuleSyntaxNode syntaxNode = new XlsModuleSyntaxNode(workbooksArray, source, this.openl, this.vocabulary, Collections.unmodifiableCollection(this.imports));
        SyntaxNodeException[] parsingErrors = this.errors.toArray(new SyntaxNodeException[this.errors.size()]);
        return new ParsedCode((ISyntaxNode)syntaxNode, source, parsingErrors, this.dependencies.toArray(new IDependency[this.dependencies.size()]));
    }

    private void preprocessEnvironmentTable(TableSyntaxNode tableSyntaxNode, XlsSheetSourceCodeModule source) {
        ILogicalTable logicalTable = tableSyntaxNode.getTable();
        int height = logicalTable.getHeight();
        for (int i = 1; i < height; ++i) {
            ILogicalTable row = (ILogicalTable)logicalTable.getRow(i);
            String name = ((ILogicalTable)row.getColumn(0)).getSource().getCell(0, 0).getStringValue();
            if ("language".equals(name)) {
                this.preprocessOpenlTable(row.getSource(), source);
                continue;
            }
            if ("dependency".equals(name)) {
                this.preprocessDependency(tableSyntaxNode, row.getSource());
                continue;
            }
            if ("include".equals(name)) {
                this.preprocessIncludeTable(tableSyntaxNode, row.getSource(), source);
                continue;
            }
            if ("import".equals(name)) {
                this.preprocessImportTable(row.getSource());
                continue;
            }
            if ("vocabulary".equals(name)) {
                this.preprocessVocabularyTable(row.getSource(), source);
                continue;
            }
            if (ParserUtils.isBlankOrCommented(name)) continue;
            String message = String.format("Error in Environment table: unrecognized keyword '%s'", name);
            this.log.warn(message);
            OpenLMessagesUtils.addWarn((String)message, (ISyntaxNode)tableSyntaxNode);
        }
    }

    private void preprocessDependency(TableSyntaxNode tableSyntaxNode, IGridTable gridTable) {
        int height = gridTable.getHeight();
        for (int i = 0; i < height; ++i) {
            String dependency = gridTable.getCell(1, i).getStringValue();
            if (!StringUtils.isNotBlank((CharSequence)dependency)) continue;
            dependency = dependency.trim();
            IdentifierNode node = new IdentifierNode("dependency", (ILocation)LocationUtils.createTextInterval((String)dependency), dependency, (IOpenSourceCodeModule)new GridCellSourceCodeModule(gridTable, 1, i, null));
            node.setParent((ISyntaxNode)tableSyntaxNode);
            Dependency moduleDependency = new Dependency(DependencyType.MODULE, node);
            this.dependencies.add((IDependency)moduleDependency);
        }
    }

    private void preprocessImportTable(IGridTable table) {
        int height = table.getHeight();
        for (int i = 0; i < height; ++i) {
            String singleImport = table.getCell(1, i).getStringValue();
            if (StringUtils.isNotBlank((CharSequence)singleImport)) {
                singleImport = singleImport.trim();
            }
            if (!StringUtils.isNotEmpty((CharSequence)singleImport)) continue;
            this.addImport(singleImport);
        }
    }

    private void addImport(String singleImport) {
        this.imports.add(singleImport);
    }

    private void addInnerImports() {
        this.addImport("org.openl.rules.enumeration");
    }

    private void preprocessIncludeTable(TableSyntaxNode tableSyntaxNode, IGridTable table, XlsSheetSourceCodeModule sheetSource) {
        int height = table.getHeight();
        for (int i = 0; i < height; ++i) {
            IOpenSourceCodeModule src;
            String include = table.getCell(1, i).getStringValue();
            if (!StringUtils.isNotBlank((CharSequence)include)) continue;
            if ((include = include.trim()).startsWith("<")) {
                src = this.includeSeeker.findInclude(StringTool.openBrackets((String)include, (char)'<', (char)'>', (String)"")[0]);
                if (src == null) {
                    this.registerIncludeError(tableSyntaxNode, table, i, include, null);
                    continue;
                }
            } else {
                try {
                    String newURL = PathTool.mergePath((String)sheetSource.getWorkbookSource().getUri(0), (String)include);
                    src = new URLSourceCodeModule(new URL(newURL));
                }
                catch (Throwable t) {
                    this.registerIncludeError(tableSyntaxNode, table, i, include, t);
                    continue;
                }
            }
            try {
                this.preprocessWorkbook(src);
                continue;
            }
            catch (Throwable t) {
                this.registerIncludeError(tableSyntaxNode, table, i, include, t);
            }
        }
    }

    private void registerIncludeError(TableSyntaxNode tableSyntaxNode, IGridTable table, int i, String include, Throwable t) {
        SyntaxNodeException se = SyntaxNodeExceptionUtils.createError((String)("Include " + include + " not found"), (Throwable)t, (ILocation)LocationUtils.createTextInterval((String)include), (IOpenSourceCodeModule)new GridCellSourceCodeModule(table, 1, i, null));
        this.addError(se);
        tableSyntaxNode.addError(se);
        OpenLMessagesUtils.addError((OpenLCompilationException)((Object)se));
    }

    private void preprocessOpenlTable(IGridTable table, XlsSheetSourceCodeModule source) {
        String openlName = table.getCell(1, 0).getStringValue();
        this.setOpenl(new OpenlSyntaxNode(openlName, new GridLocation(table), source));
    }

    private TableSyntaxNode preprocessTable(IGridTable table, XlsSheetSourceCodeModule source, TablePartProcessor tablePartProcessor) throws OpenLCompilationException {
        TableSyntaxNode tsn = XlsHelper.createTableSyntaxNode(table, source);
        String type = tsn.getType();
        if (type.equals(XlsNodeTypes.XLS_ENVIRONMENT.toString())) {
            this.preprocessEnvironmentTable(tsn, source);
        } else if (type.equals(XlsNodeTypes.XLS_TABLEPART.toString())) {
            try {
                tablePartProcessor.register(table, source);
            }
            catch (Throwable t) {
                tsn = new TableSyntaxNode(XlsNodeTypes.XLS_OTHER.toString(), tsn.getGridLocation(), source, table, tsn.getHeader());
                SyntaxNodeException sne = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tsn);
                this.addError(sne);
                tsn.addError(sne);
                OpenLMessagesUtils.addError((OpenLCompilationException)((Object)sne));
            }
        }
        return tsn;
    }

    private void preprocessVocabularyTable(IGridTable table, XlsSheetSourceCodeModule source) {
        String vocabularyStr = table.getCell(1, 0).getStringValue();
        this.setVocabulary(new IdentifierNode("vocabulary", (ILocation)new GridLocation(table), vocabularyStr, (IOpenSourceCodeModule)source));
    }

    private WorkbookSyntaxNode preprocessWorkbook(IOpenSourceCodeModule source) {
        String uri = source.getUri(0);
        if (this.preprocessedWorkBooks.contains(uri)) {
            return null;
        }
        this.preprocessedWorkBooks.add(uri);
        XlsWorkbookSourceCodeModule workbookSourceModule = new XlsWorkbookSourceCodeModule(source);
        int nsheets = workbookSourceModule.getWorkbookLoader().getNumberOfSheets();
        WorksheetSyntaxNode[] sheetNodes = new WorksheetSyntaxNode[nsheets];
        TablePartProcessor tablePartProcessor = new TablePartProcessor();
        for (int i = 0; i < nsheets; ++i) {
            XlsSheetSourceCodeModule sheetSource = new XlsSheetSourceCodeModule(i, workbookSourceModule);
            sheetNodes[i] = this.createWorksheetSyntaxNode(sheetSource, tablePartProcessor);
        }
        TableSyntaxNode[] mergedNodes = new TableSyntaxNode[]{};
        try {
            List<TablePart> tableParts = tablePartProcessor.mergeAllNodes();
            int n = tableParts.size();
            mergedNodes = new TableSyntaxNode[n];
            for (int i = 0; i < n; ++i) {
                mergedNodes[i] = this.preprocessTable(tableParts.get(i).getTable(), tableParts.get(i).getSource(), tablePartProcessor);
            }
        }
        catch (OpenLCompilationException e) {
            OpenLMessagesUtils.addError((OpenLCompilationException)e);
        }
        WorkbookSyntaxNode workbookNode = new WorkbookSyntaxNode(sheetNodes, mergedNodes, workbookSourceModule);
        this.workbookNodes.add(workbookNode);
        return workbookNode;
    }

    private WorksheetSyntaxNode createWorksheetSyntaxNode(XlsSheetSourceCodeModule sheetSource, TablePartProcessor tablePartProcessor) {
        IGridTable[] tables = this.getAllGridTables(sheetSource);
        ArrayList<TableSyntaxNode> tableNodes = new ArrayList<TableSyntaxNode>();
        for (IGridTable table : tables) {
            try {
                TableSyntaxNode tsn = this.preprocessTable(table, sheetSource, tablePartProcessor);
                tableNodes.add(tsn);
            }
            catch (OpenLCompilationException e) {
                OpenLMessagesUtils.addError((OpenLCompilationException)e);
            }
        }
        return new WorksheetSyntaxNode(tableNodes.toArray(new TableSyntaxNode[tableNodes.size()]), sheetSource);
    }

    private IGridTable[] getAllGridTables(XlsSheetSourceCodeModule sheetSource) {
        XlsSheetGridModel xlsGrid = new XlsSheetGridModel(sheetSource);
        return xlsGrid.getTables();
    }

    private void setOpenl(OpenlSyntaxNode openl) {
        if (this.openl == null) {
            this.openl = openl;
        } else if (!this.openl.getOpenlName().equals(openl.getOpenlName())) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Only one openl statement is allowed", null, (ISyntaxNode)openl);
            OpenLMessagesUtils.addError((OpenLCompilationException)((Object)error));
            this.addError(error);
        }
    }

    private void setVocabulary(IdentifierNode vocabulary) {
        if (this.vocabulary == null) {
            this.vocabulary = vocabulary;
        } else {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Only one vocabulary is allowed", null, (ISyntaxNode)vocabulary);
            OpenLMessagesUtils.addError((OpenLCompilationException)((Object)error));
            this.addError(error);
        }
    }
}

