/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.io.File;
import java.util.SortedMap;
import org.openl.rules.lang.xls.XlsWorkbookListener;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.source.SourceHistoryManager;

public class XlsWorkbookSourceHistoryListener
implements XlsWorkbookListener {
    private SourceHistoryManager<File> historyManager;

    public XlsWorkbookSourceHistoryListener(SourceHistoryManager<File> historyManager) {
        if (historyManager == null) {
            throw new IllegalArgumentException();
        }
        this.historyManager = historyManager;
    }

    @Override
    public void beforeSave(XlsWorkbookSourceCodeModule workbookSourceCodeModule) {
        File sourceFile = workbookSourceCodeModule.getSourceFile();
        this.beforeSave(sourceFile);
    }

    public void beforeSave(File sourceFile) {
        SortedMap sources = this.historyManager.get(new String[]{sourceFile.getName()});
        if (sources.isEmpty() && sourceFile.exists()) {
            this.historyManager.save((Object)sourceFile);
        }
    }

    @Override
    public void afterSave(XlsWorkbookSourceCodeModule workbookSourceCodeModule) {
        File sourceFile = workbookSourceCodeModule.getSourceFile();
        this.afterSave(sourceFile);
    }

    public void afterSave(File sourceFile) {
        this.historyManager.save((Object)sourceFile);
    }
}

