/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.binding.exception.DuplicatedMethodException;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.impl.module.DeferredMethod;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.dependency.CompiledDependency;
import org.openl.engine.ExtendableModuleOpenClass;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.Severity;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.cmatch.ColumnMatch;
import org.openl.rules.data.DataOpenField;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.binding.DuplicatedTableException;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.wrapper.AlgorithmSubroutineMethodWrapper;
import org.openl.rules.lang.xls.binding.wrapper.AlgorithmWrapper;
import org.openl.rules.lang.xls.binding.wrapper.ColumnMatchWrapper;
import org.openl.rules.lang.xls.binding.wrapper.CompositeMethodWrapper;
import org.openl.rules.lang.xls.binding.wrapper.DecisionTable2Wrapper;
import org.openl.rules.lang.xls.binding.wrapper.DeferredMethodWrapper;
import org.openl.rules.lang.xls.binding.wrapper.IOpenMethodWrapper;
import org.openl.rules.lang.xls.binding.wrapper.JavaOpenMethodWrapper;
import org.openl.rules.lang.xls.binding.wrapper.MatchingOpenMethodDispatcherWrapper;
import org.openl.rules.lang.xls.binding.wrapper.OverloadedMethodsDispatcherTableWrapper;
import org.openl.rules.lang.xls.binding.wrapper.SpreadsheetWrapper;
import org.openl.rules.lang.xls.binding.wrapper.TableMethodWrapper;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.method.table.TableMethod;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.tbasic.Algorithm;
import org.openl.rules.tbasic.AlgorithmSubroutineMethod;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.types.ValidationMessages;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.rules.types.impl.OverloadedMethodsDispatcherTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IModuleInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AMethod;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenMethod;

public class XlsModuleOpenClass
extends ModuleOpenClass
implements ExtendableModuleOpenClass {
    protected Set<String> duplicatedMethodUrls = new HashSet<String>();
    private IDataBase dataBase = null;
    private boolean useDescisionTableDispatcher;
    private boolean dispatchingValidationEnabled;
    private Collection<String> imports = new HashSet<String>();
    private ClassLoader classLoader;

    public XlsModuleOpenClass(String name, XlsMetaInfo metaInfo, OpenL openl, IDataBase dbase, Set<CompiledDependency> usingModules, ClassLoader classLoader, boolean useDescisionTableDispatcher, boolean dispatchingValidationEnabled) {
        super(name, openl);
        this.dataBase = dbase;
        this.metaInfo = metaInfo;
        this.useDescisionTableDispatcher = useDescisionTableDispatcher;
        this.dispatchingValidationEnabled = dispatchingValidationEnabled;
        this.classLoader = classLoader;
        if (usingModules != null) {
            this.setDependencies(usingModules);
            this.initDependencies();
        }
        this.initImports(metaInfo.getXlsModuleNode());
        this.additionalInitDependencies();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void initImports(XlsModuleSyntaxNode xlsModuleSyntaxNode) {
        this.imports.addAll(xlsModuleSyntaxNode.getImports());
    }

    public IDataBase getDataBase() {
        return this.dataBase;
    }

    private void additionalInitDependencies() {
        for (CompiledDependency dependency : this.getDependencies()) {
            this.addDataTables(dependency.getCompiledOpenClass());
        }
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    public void applyToDependentParsedCode(IParsedCode parsedCode) {
        if (parsedCode == null) {
            throw new IllegalArgumentException("parsedCode argument can't be null!");
        }
        if (parsedCode.getTopNode() instanceof XlsModuleSyntaxNode) {
            XlsModuleSyntaxNode xlsModuleSyntaxNode = (XlsModuleSyntaxNode)parsedCode.getTopNode();
            for (String value : this.getImports()) {
                xlsModuleSyntaxNode.addImport(value);
            }
        }
    }

    private void addDataTables(CompiledOpenClass dependency) {
        XlsModuleOpenClass xlsModuleOpenClass;
        IOpenClass openClass = dependency.getOpenClassWithErrors();
        Map fieldsMap = openClass.getFields();
        HashSet<String> tableUrls = new HashSet<String>();
        Map fields = this.getFields();
        for (IOpenField openField : fields.values()) {
            if (!(openField instanceof DataOpenField)) continue;
            tableUrls.add(((DataOpenField)openField).getTableUri());
        }
        for (String key : fieldsMap.keySet()) {
            IOpenField field = (IOpenField)fieldsMap.get(key);
            if (!(field instanceof DataOpenField)) continue;
            DataOpenField dataOpenField = (DataOpenField)field;
            try {
                String tableUrl = dataOpenField.getTableUri();
                if (tableUrls.contains(tableUrl) || this.duplicatedMethodUrls.contains(tableUrl)) continue;
                boolean containsInDependency = false;
                if ("<virtual_uri>".equals(this.metaInfo.getSourceUrl())) {
                    for (CompiledDependency d : this.getDependencies()) {
                        IOpenClass dependentModuleClass = d.getCompiledOpenClass().getOpenClassWithErrors();
                        if (!(dependentModuleClass instanceof XlsModuleOpenClass) || !((XlsModuleOpenClass)dependentModuleClass).duplicatedMethodUrls.contains(tableUrl)) continue;
                        containsInDependency = true;
                        break;
                    }
                }
                if (containsInDependency) continue;
                this.addField(field);
                tableUrls.add(tableUrl);
            }
            catch (OpenlNotCheckedException e) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)e.getMessage(), (Throwable)e, (ISyntaxNode)dataOpenField.getTable().getTableSyntaxNode());
                this.addError(error);
            }
        }
        if (openClass instanceof XlsModuleOpenClass && (xlsModuleOpenClass = (XlsModuleOpenClass)openClass).getDataBase() != null) {
            for (ITable table : xlsModuleOpenClass.getDataBase().getTables()) {
                if (!XlsNodeTypes.XLS_DATA.toString().equals(table.getTableSyntaxNode().getType())) continue;
                try {
                    this.getDataBase().registerTable(table);
                }
                catch (DuplicatedTableException e) {
                    this.addError((Throwable)((Object)e));
                }
                catch (OpenlNotCheckedException e) {
                    this.addError(e);
                }
            }
        }
    }

    public XlsMetaInfo getXlsMetaInfo() {
        return (XlsMetaInfo)this.metaInfo;
    }

    protected IOpenMethod undecorateForMultimoduleDispatching(IOpenMethod openMethod) {
        if (openMethod instanceof IOpenMethodWrapper) {
            IOpenMethodWrapper dispatchWrapper = (IOpenMethodWrapper)openMethod;
            return dispatchWrapper.getDelegate();
        }
        return openMethod;
    }

    protected IOpenMethod decorateForMultimoduleDispatching(IOpenMethod openMethod) {
        if (openMethod instanceof IOpenMethodWrapper || openMethod instanceof TestSuiteMethod) {
            return openMethod;
        }
        if (openMethod instanceof OverloadedMethodsDispatcherTable) {
            return new OverloadedMethodsDispatcherTableWrapper(this, (OverloadedMethodsDispatcherTable)openMethod);
        }
        if (openMethod instanceof MatchingOpenMethodDispatcher) {
            return new MatchingOpenMethodDispatcherWrapper(this, (MatchingOpenMethodDispatcher)openMethod);
        }
        if (openMethod instanceof DeferredMethod) {
            return new DeferredMethodWrapper(this, (DeferredMethod)openMethod);
        }
        if (openMethod instanceof CompositeMethod) {
            return new CompositeMethodWrapper(this, (CompositeMethod)openMethod);
        }
        if (openMethod instanceof Algorithm) {
            return new AlgorithmWrapper(this, (Algorithm)openMethod);
        }
        if (openMethod instanceof AlgorithmSubroutineMethod) {
            return new AlgorithmSubroutineMethodWrapper(this, (AlgorithmSubroutineMethod)openMethod);
        }
        if (openMethod instanceof DecisionTable) {
            return new DecisionTable2Wrapper(this, (DecisionTable)openMethod);
        }
        if (openMethod instanceof ColumnMatch) {
            return new ColumnMatchWrapper(this, (ColumnMatch)openMethod);
        }
        if (openMethod instanceof Spreadsheet) {
            return new SpreadsheetWrapper(this, (Spreadsheet)openMethod);
        }
        if (openMethod instanceof TableMethod) {
            return new TableMethodWrapper(this, (TableMethod)openMethod);
        }
        if (openMethod instanceof JavaOpenMethod) {
            return new JavaOpenMethodWrapper(this, (JavaOpenMethod)openMethod);
        }
        return openMethod;
    }

    public void addMethod(IOpenMethod method) {
        block16: {
            OpenMethodDispatcher dispatcher;
            IOpenMethod existedMethod;
            IOpenSourceCodeModule sourceCodeModule;
            XlsMetaInfo metaInfo;
            if (method instanceof OpenMethodDispatcher) {
                this.addDispatcherMethod((OpenMethodDispatcher)method);
                return;
            }
            IOpenMethod m = this.decorateForMultimoduleDispatching(method);
            if (m instanceof AMethod && ((AMethod)m).getModuleName() == null && (metaInfo = this.getXlsMetaInfo()) != null && (sourceCodeModule = metaInfo.getXlsModuleNode().getModule()) instanceof IModuleInfo) {
                ((AMethod)m).setModuleName(((IModuleInfo)sourceCodeModule).getModuleName());
            }
            if ((existedMethod = this.getDeclaredMethod(method.getName(), method.getSignature().getParameterTypes())) != null) {
                String message;
                if (!existedMethod.getType().equals(method.getType())) {
                    message = String.format("Method \"%s\" with return type \"%s\" has already been defined with another return type (\"%s\")", method.getName(), method.getType().getDisplayName(0), existedMethod.getType().getDisplayName(0));
                    this.addDuplicatedMethodError(message, method, existedMethod);
                    return;
                }
                if (method != existedMethod && method instanceof TestSuiteMethod) {
                    this.duplicatedMethodUrls.add(method.getInfo().getSourceUrl());
                    message = ValidationMessages.getDuplicatedMethodMessage(existedMethod, method);
                    this.addDuplicatedMethodError(message, method, existedMethod);
                    return;
                }
                try {
                    if (existedMethod instanceof OpenMethodDispatcher) {
                        OpenMethodDispatcher decorator = (OpenMethodDispatcher)existedMethod;
                        decorator.addMethod(this.undecorateForMultimoduleDispatching(m));
                    } else if (m != existedMethod) {
                        dispatcher = this.getOpenMethodDispatcher(existedMethod);
                        IOpenMethod openMethod = this.decorateForMultimoduleDispatching(dispatcher);
                        this.overrideMethod(openMethod);
                        dispatcher.addMethod(this.undecorateForMultimoduleDispatching(m));
                    }
                }
                catch (DuplicatedMethodException e) {
                    IMemberMetaInfo memberMetaInfo;
                    SyntaxNodeException error = null;
                    if (m instanceof IMemberMetaInfo && (memberMetaInfo = (IMemberMetaInfo)m).getSyntaxNode() != null && memberMetaInfo.getSyntaxNode() instanceof TableSyntaxNode) {
                        error = SyntaxNodeExceptionUtils.createError((String)e.getMessage(), (Throwable)e, (ISyntaxNode)memberMetaInfo.getSyntaxNode());
                        ((TableSyntaxNode)memberMetaInfo.getSyntaxNode()).addError(error);
                    }
                    boolean f = false;
                    for (Throwable t : this.getErrors()) {
                        if (!t.getMessage().equals(e.getMessage())) continue;
                        f = true;
                        break;
                    }
                    if (f) break block16;
                    if (error != null) {
                        this.addError(error);
                        break block16;
                    }
                    this.addError(e);
                }
            } else if (this.dispatchingValidationEnabled && !(m instanceof TestSuiteMethod) && this.dimensionalPropertyPresented(m)) {
                dispatcher = this.getOpenMethodDispatcher(m);
                IOpenMethod openMethod = this.decorateForMultimoduleDispatching(dispatcher);
                super.addMethod(openMethod);
            } else {
                super.addMethod(m);
            }
        }
    }

    private boolean dimensionalPropertyPresented(IOpenMethod m) {
        List<TablePropertyDefinition> dimensionalPropertiesDef = TablePropertyDefinitionUtils.getDimensionalTableProperties();
        ITableProperties propertiesFromMethod = PropertiesHelper.getTableProperties(m);
        for (TablePropertyDefinition dimensionProperty : dimensionalPropertiesDef) {
            String propertyValue = propertiesFromMethod.getPropertyValueAsString(dimensionProperty.getName());
            if (!StringUtils.isNotEmpty((CharSequence)propertyValue)) continue;
            return true;
        }
        return false;
    }

    public void addDispatcherMethod(OpenMethodDispatcher dispatcher) {
        for (IOpenMethod candidate : dispatcher.getCandidates()) {
            this.addMethod(candidate);
        }
    }

    private OpenMethodDispatcher getOpenMethodDispatcher(IOpenMethod method) {
        IOpenMethod decorated = this.undecorateForMultimoduleDispatching(method);
        MatchingOpenMethodDispatcher decorator = this.useDescisionTableDispatcher ? new OverloadedMethodsDispatcherTable(decorated, this) : new MatchingOpenMethodDispatcher(decorated, this);
        return decorator;
    }

    public void clearOddDataForExecutionMode() {
        super.clearOddDataForExecutionMode();
        this.dataBase = null;
    }

    public void addError(Throwable error) {
        if ((error instanceof DuplicatedMethodException || error instanceof DuplicatedVarException || error instanceof DuplicatedTableException || error instanceof SyntaxNodeException) && "<virtual_uri>".equals(this.metaInfo.getSourceUrl())) {
            for (CompiledDependency dependency : this.getDependencies()) {
                List errors = OpenLMessagesUtils.filterMessagesBySeverity((List)dependency.getCompiledOpenClass().getMessages(), (Severity)Severity.ERROR);
                for (OpenLMessage message : errors) {
                    if (message.getSummary() == null || !message.getSummary().equals(error.getMessage())) continue;
                    return;
                }
            }
        }
        super.addError(error);
    }

    private void addDuplicatedMethodError(String message, IOpenMethod method, IOpenMethod existedMethod) {
        ISyntaxNode newMethodSyntaxNode = method.getInfo().getSyntaxNode();
        if (newMethodSyntaxNode instanceof TableSyntaxNode) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)newMethodSyntaxNode);
            ((TableSyntaxNode)newMethodSyntaxNode).addError(error);
            TableSyntaxNode existedMethodSyntaxNode = (TableSyntaxNode)existedMethod.getInfo().getSyntaxNode();
            if (existedMethodSyntaxNode != null) {
                existedMethodSyntaxNode.addError(SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)existedMethodSyntaxNode));
            }
            this.addError(error);
        } else {
            this.addError(new DuplicatedMethodException(message, method));
        }
    }
}

