/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.classes;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openl.rules.lang.xls.classes.ClassLocator;
import org.openl.rules.lang.xls.classes.LocatorExceptionHandler;

public class JarClassLocator
implements ClassLocator {
    private final List<LocatorExceptionHandler> handlers;

    public JarClassLocator() {
        this(new ArrayList());
    }

    public JarClassLocator(List<? extends LocatorExceptionHandler> handlers) {
        this.handlers = new ArrayList<LocatorExceptionHandler>(handlers);
    }

    public void addExceptionHandler(LocatorExceptionHandler handler) {
        this.handlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Class<?>> getClasses(URL pathURL, String packageName, ClassLoader classLoader) {
        URL jar;
        String jarPath = pathURL.getFile().split("!")[0];
        try {
            jar = new URL(jarPath);
        }
        catch (MalformedURLException e) {
            for (LocatorExceptionHandler handler : this.handlers) {
                handler.handleURLParseException(e);
            }
            return Collections.emptySet();
        }
        HashSet classes = new HashSet();
        ZipInputStream zip = null;
        try {
            ZipEntry entry;
            zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                String fullClassName;
                if (!entry.getName().endsWith(".class") || !(fullClassName = entry.getName().replace(".class", "").replace('/', '.')).startsWith(packageName) || (className = fullClassName.substring(packageName.length() + 1)).contains(".") || className.contains("$")) continue;
                try {
                    classes.add(Class.forName(fullClassName, true, classLoader));
                }
                catch (Throwable t) {
                    for (LocatorExceptionHandler handler : this.handlers) {
                        handler.handleClassInstatiateException(t);
                    }
                }
            }
        }
        catch (IOException e) {
            for (LocatorExceptionHandler handler : this.handlers) {
                handler.handleIOException(e);
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    for (LocatorExceptionHandler handler : this.handlers) {
                        handler.handleIOException(e);
                    }
                }
            }
        }
        return classes;
    }
}

