/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.load;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.openl.rules.lang.xls.load.LazyWorkbookLoader;
import org.openl.rules.lang.xls.load.WorkbookLoader;
import org.openl.rules.lang.xls.load.WorkbookLoaderFactory;
import org.openl.source.IOpenSourceCodeModule;

public class LazyWorkbookLoaderFactory
implements WorkbookLoaderFactory {
    private Set<WorkbookLoader> workbookLoadersCache = Collections.newSetFromMap(new WeakHashMap());
    private boolean canUnload = true;

    @Override
    public WorkbookLoader createWorkbookLoader(IOpenSourceCodeModule fileSource) {
        LazyWorkbookLoader workbookLoader = new LazyWorkbookLoader(fileSource);
        workbookLoader.setCanUnload(this.canUnload);
        if (!this.canUnload) {
            this.workbookLoadersCache.add(workbookLoader);
        }
        return workbookLoader;
    }

    public void disallowUnload() {
        this.canUnload = false;
    }

    public void allowUnload() {
        this.canUnload = true;
        for (WorkbookLoader workbookLoader : this.workbookLoadersCache) {
            workbookLoader.setCanUnload(true);
        }
        this.workbookLoadersCache.clear();
    }
}

