/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.load;

import java.io.InputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.openl.exception.OpenLRuntimeException;
import org.openl.source.IOpenSourceCodeModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WorkbookLoadUtils {
    private WorkbookLoadUtils() {
    }

    static Workbook loadWorkbook(IOpenSourceCodeModule fileSource) {
        Workbook workbook;
        Logger log = LoggerFactory.getLogger(WorkbookLoadUtils.class);
        log.debug("Loading workbook '{}'...", (Object)fileSource.getUri(0));
        InputStream is = null;
        try {
            is = fileSource.getByteStream();
            workbook = WorkbookFactory.create((InputStream)is);
        }
        catch (Exception e) {
            log.error("Error while preprocessing workbook", (Throwable)e);
            String message = "Can't open source file or file is corrupted: " + ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new OpenLRuntimeException(message, (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable e) {
                log.error("Error trying close input stream:", e);
            }
        }
        return workbook;
    }
}

