/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.openl.binding.impl.NodeUsage;
import org.openl.rules.table.ICell;
import org.openl.types.IOpenClass;

public class CellMetaInfo {
    private Type type;
    private IOpenClass domain;
    private String paramName;
    private boolean multiValue;
    private List<? extends NodeUsage> usedNodes;

    public CellMetaInfo(Type type, String paramName, IOpenClass domain, boolean multiValue) {
        this(type, paramName, domain, multiValue, null);
    }

    public CellMetaInfo(Type type, String paramName, IOpenClass domain, boolean multiValue, List<? extends NodeUsage> usedNodes) {
        this.type = type;
        this.domain = domain;
        this.paramName = paramName;
        this.setMultiValue(multiValue);
        this.usedNodes = usedNodes;
    }

    public IOpenClass getDataType() {
        return this.domain;
    }

    public String getParamName() {
        return this.paramName;
    }

    public Type getType() {
        return this.type;
    }

    public void setMultiValue(boolean multiValue) {
        this.multiValue = multiValue;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public List<? extends NodeUsage> getUsedNodes() {
        return this.usedNodes;
    }

    public void setUsedNodes(List<? extends NodeUsage> usedNodes) {
        this.usedNodes = usedNodes;
    }

    public boolean hasNodeUsagesInCell() {
        return !CollectionUtils.isEmpty(this.getUsedNodes());
    }

    public static boolean isCellContainsNodeUsages(ICell cell) {
        return cell.getMetaInfo() != null && cell.getMetaInfo().hasNodeUsagesInCell();
    }

    public static enum Type {
        TABLE_HEADER,
        TABLE_PROPERTIES,
        DT_CA_HEADER,
        DT_CA_CODE,
        DT_CA_DISPLAY,
        DT_DATA_CELL;

    }
}

