/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.runtime;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.context.IRulesRuntimeContextProvider;
import org.openl.rules.datatype.gen.BeanByteCodeGenerator;
import org.openl.rules.runtime.InterfaceClassGenerator;
import org.openl.rules.runtime.InterfaceClassGeneratorImpl;
import org.openl.rules.runtime.OpenLRulesInvocationHandler;
import org.openl.rules.vm.SimpleRulesVM;
import org.openl.runtime.EngineFactory;
import org.openl.runtime.IEngineWrapper;
import org.openl.runtime.IRuntimeEnvBuilder;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesEngineFactory<T>
extends EngineFactory<T> {
    private final Logger log = LoggerFactory.getLogger(RulesEngineFactory.class);
    private static final String RULES_XLS_OPENL_NAME = "org.openl.xls";
    private InterfaceClassGenerator interfaceClassGenerator = new InterfaceClassGeneratorImpl();
    private IRuntimeEnvBuilder runtimeEnvBuilder = null;

    public void setInterfaceClassGenerator(InterfaceClassGenerator interfaceClassGenerator) {
        if (interfaceClassGenerator == null) {
            throw new IllegalArgumentException("interfaceClassGenerator argument can't be null");
        }
        if (super.getInterfaceClass() != null) {
            this.log.warn("Rules engine factory has already had interface class. Interface class generator will be ignored!");
        }
        this.interfaceClassGenerator = interfaceClassGenerator;
    }

    public InterfaceClassGenerator getInterfaceClassGenerator() {
        return this.interfaceClassGenerator;
    }

    public RulesEngineFactory(String sourceFile) {
        this(new File(sourceFile));
    }

    public RulesEngineFactory(String sourceFile, Class<T> interfaceClass) {
        this(new File(sourceFile));
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String sourceFile, String userHome) {
        super(RULES_XLS_OPENL_NAME, sourceFile, userHome);
    }

    public RulesEngineFactory(String sourceFile, String userHome, Class<T> interfaceClass) {
        super(RULES_XLS_OPENL_NAME, sourceFile, userHome);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(File file) {
        super(RULES_XLS_OPENL_NAME, file);
    }

    public RulesEngineFactory(File file, Class<T> interfaceClass) {
        super(RULES_XLS_OPENL_NAME, file);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(IOpenSourceCodeModule sourceCodeModule) {
        super(RULES_XLS_OPENL_NAME, sourceCodeModule);
    }

    public RulesEngineFactory(IOpenSourceCodeModule sourceCodeModule, Class<T> interfaceClass) {
        super(RULES_XLS_OPENL_NAME, sourceCodeModule);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(IOpenSourceCodeModule source, String userHome) {
        super(RULES_XLS_OPENL_NAME, source, userHome);
    }

    public RulesEngineFactory(IOpenSourceCodeModule source, String userHome, Class<T> interfaceClass) {
        super(RULES_XLS_OPENL_NAME, source, userHome);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(URL source) {
        super(RULES_XLS_OPENL_NAME, source);
    }

    public RulesEngineFactory(URL source, Class<T> interfaceClass) {
        super(RULES_XLS_OPENL_NAME, source);
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Interface can't be null!");
        }
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(String openlName, IOpenSourceCodeModule sourceCode, Class<T> interfaceClass) {
        super(openlName, sourceCode);
        super.setInterfaceClass(interfaceClass);
    }

    public RulesEngineFactory(IOpenSourceCodeModule source, String userHome, String openlName) {
        super(openlName, source, userHome);
    }

    public void reset(boolean resetInterface) {
        super.reset();
        if (resetInterface) {
            this.setInterfaceClass(null);
        }
    }

    public Class<T> getInterfaceClass() {
        if (super.getInterfaceClass() == null) {
            IOpenClass openClass = this.getCompiledOpenClass().getOpenClass();
            String className = openClass.getName();
            ClassLoader classLoader = this.getCompiledOpenClass().getClassLoader();
            try {
                if (BeanByteCodeGenerator.isClassLoaderContainsClass(classLoader, className)) {
                    this.log.warn("Previously generated  interface '{}' will be used as service class.", (Object)className);
                    Class<?> interfaceClass = classLoader.loadClass(className);
                    this.setInterfaceClass(interfaceClass);
                    return interfaceClass;
                }
                Class<?> interfaceClass = this.interfaceClassGenerator.generateInterface(className, openClass, classLoader);
                this.setInterfaceClass(interfaceClass);
                return interfaceClass;
            }
            catch (Exception e) {
                throw new OpenlNotCheckedException("Failed to generate interface : " + className, (Throwable)e);
            }
        }
        return super.getInterfaceClass();
    }

    protected Class<?>[] prepareInstanceInterfaces() {
        return new Class[]{this.getInterfaceClass(), IEngineWrapper.class, IRulesRuntimeContextProvider.class};
    }

    protected IRuntimeEnvBuilder getRuntimeEnvBuilder() {
        if (this.runtimeEnvBuilder == null) {
            this.runtimeEnvBuilder = new IRuntimeEnvBuilder(){

                public IRuntimeEnv buildRuntimeEnv() {
                    return new SimpleRulesVM().getRuntimeEnv();
                }
            };
        }
        return this.runtimeEnvBuilder;
    }

    protected InvocationHandler prepareInvocationHandler(Object openClassInstance, Map<Method, IOpenMember> methodMap, IRuntimeEnv runtimeEnv) {
        return new OpenLRulesInvocationHandler(openClassInstance, runtimeEnv, methodMap);
    }
}

