/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.GridRegion;
import org.openl.rules.table.GridTableCell;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.SingleCellGridTable;
import org.openl.rules.table.SubGridTable;
import org.openl.rules.table.TransposedGridTable;

public abstract class AGridTable
implements IGridTable {
    @Override
    public IGridRegion getRegion() {
        int left = this.getGridColumn(0, 0);
        int top = this.getGridRow(0, 0);
        int right = -1;
        int bottom = -1;
        if (this.isNormalOrientation()) {
            right = this.getGridColumn(this.getWidth() - 1, 0);
            bottom = this.getGridRow(0, this.getHeight() - 1);
        } else {
            right = this.getGridColumn(0, this.getHeight() - 1);
            bottom = this.getGridRow(this.getWidth() - 1, 0);
        }
        return new GridRegion(top, left, bottom, right);
    }

    @Override
    public String getUri() {
        int w = this.getWidth();
        int h = this.getHeight();
        return this.getGrid().getRangeUri(this.getGridColumn(0, 0), this.getGridRow(0, 0), this.getGridColumn(w - 1, h - 1), this.getGridRow(w - 1, h - 1));
    }

    @Override
    public String getUri(int col, int row) {
        int colStart = this.getGridColumn(col, row);
        int rowStart = this.getGridRow(col, row);
        return this.getGrid().getRangeUri(colStart, rowStart, colStart, rowStart);
    }

    @Override
    public IGridTable transpose() {
        return new TransposedGridTable(this);
    }

    @Override
    public ICell getCell(int column, int row) {
        return new GridTableCell(column, row, this);
    }

    @Override
    public IGridTable getColumn(int column) {
        return this.getColumns(column, column);
    }

    @Override
    public IGridTable getColumns(int from) {
        return this.getColumns(from, this.getWidth() - 1);
    }

    @Override
    public IGridTable getColumns(int from, int to) {
        int colsNum = to - from + 1;
        return this.getSubtable(from, 0, colsNum, this.getHeight());
    }

    @Override
    public IGridTable getRow(int row) {
        return this.getRows(row, row);
    }

    @Override
    public IGridTable getRows(int from) {
        return this.getRows(from, this.getHeight() - 1);
    }

    @Override
    public IGridTable getRows(int from, int to) {
        int rowsNum = to - from + 1;
        return this.getSubtable(0, from, this.getWidth(), rowsNum);
    }

    @Override
    public IGridTable getSubtable(int column, int row, int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        if (this.getWidth() == width && this.getHeight() == height) {
            return this;
        }
        if (width == 1 && height == 1) {
            return new SingleCellGridTable(this, column, row);
        }
        return new SubGridTable(this, column, row, width, height);
    }

    public String toString() {
        StringBuilder tableVizualization = new StringBuilder();
        tableVizualization.append(super.toString() + (this.isNormalOrientation() ? "[N]" : "[T]") + "(" + this.getWidth() + " x " + this.getHeight() + ")" + this.getRegion().toString() + "\n");
        for (int i = 0; i < this.getHeight(); ++i) {
            int length = 0;
            for (int j = 0; j < this.getWidth(); ++j) {
                String strValue = this.getCell(j, i).getStringValue();
                if (strValue == null) {
                    strValue = "EMPTY";
                }
                length += strValue.length();
                tableVizualization.append(strValue);
                tableVizualization.append("|");
            }
            tableVizualization.append("\n");
            for (int k = 0; k <= length; ++k) {
                tableVizualization.append("-");
            }
            tableVizualization.append("\n");
        }
        return tableVizualization.toString();
    }
}

