/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.Point;

public class GridRegion
implements IGridRegion {
    private int top;
    private int left;
    private int bottom;
    private int right;

    public GridRegion(IGridRegion g) {
        this.top = g.getTop();
        this.left = g.getLeft();
        this.bottom = g.getBottom();
        this.right = g.getRight();
    }

    public GridRegion(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public GridRegion(IGridRegion reg, short side, int coord) {
        this(reg);
        switch (side) {
            case 0: {
                this.top = coord;
                break;
            }
            case 1: {
                this.left = coord;
                break;
            }
            case 3: {
                this.right = coord;
                break;
            }
            case 2: {
                this.bottom = coord;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong IGridRegion side argument: " + side);
            }
        }
    }

    @Override
    public int getBottom() {
        return this.bottom;
    }

    @Override
    public int getLeft() {
        return this.left;
    }

    @Override
    public int getRight() {
        return this.right;
    }

    @Override
    public int getTop() {
        return this.top;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public String toString() {
        return "[" + this.getTop() + "," + this.getLeft() + "," + this.getBottom() + "," + this.getRight() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bottom;
        result = 31 * result + this.left;
        result = 31 * result + this.right;
        result = 31 * result + this.top;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridRegion other = (GridRegion)obj;
        if (this.bottom != other.bottom) {
            return false;
        }
        if (this.left != other.left) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        return this.top == other.top;
    }

    public static IGridRegion shiftRight(Point start, int shiftRight) {
        return new GridRegion(start.getRow(), start.getColumn(), start.getRow(), start.getColumn() + shiftRight);
    }

    public static IGridRegion shiftBottom(Point start, int shiftBottom) {
        return new GridRegion(start.getRow(), start.getColumn(), start.getRow() + shiftBottom, start.getColumn());
    }
}

