/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.AGridTable;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;

public class GridTable
extends AGridTable {
    private IGridRegion region;
    private IGrid grid;

    public GridTable(IGridRegion reg, IGrid grid) {
        this.region = reg;
        this.grid = grid;
    }

    public GridTable(int top, int left, int bottom, int right, IGrid grid) {
        this(new GridRegion(top, left, bottom, right), grid);
    }

    @Override
    public int getWidth() {
        return this.region.getRight() - this.region.getLeft() + 1;
    }

    @Override
    public int getHeight() {
        return this.region.getBottom() - this.region.getTop() + 1;
    }

    @Override
    public IGrid getGrid() {
        return this.grid;
    }

    @Override
    public int getGridColumn(int column, int row) {
        return this.region.getLeft() + column;
    }

    @Override
    public int getGridRow(int column, int row) {
        return this.region.getTop() + row;
    }

    @Override
    public IGridRegion getRegion() {
        return this.region;
    }

    @Override
    public boolean isNormalOrientation() {
        return true;
    }
}

