/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.GridTable;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTable;
import org.openl.rules.table.SimpleLogicalTable;

public class LogicalTableHelper {
    private LogicalTableHelper() {
    }

    public static int calcLogicalColumns(IGridTable table) {
        int W = table.getWidth();
        if (W == 1) {
            return 1;
        }
        int columns = 0;
        int w = 0;
        while (w < W) {
            int cellWidth = table.getCell(w, 0).getWidth();
            w += cellWidth;
            ++columns;
        }
        return columns;
    }

    public static int calcLogicalRows(IGridTable table) {
        int H = table.getHeight();
        if (H == 1) {
            return 1;
        }
        int rows = 0;
        int h = 0;
        while (h < H) {
            int cellHeight = table.getCell(0, h).getHeight();
            h += cellHeight;
            ++rows;
        }
        return rows;
    }

    public static ILogicalTable logicalTable(IGridTable table, ILogicalTable columnOffsetsTable, ILogicalTable rowOffsetsTable) {
        int[] columnOffsets = null;
        if (columnOffsetsTable != null && columnOffsetsTable instanceof LogicalTable) {
            columnOffsets = ((LogicalTable)columnOffsetsTable).getColumnOffset();
        }
        int[] rowOffsets = null;
        if (rowOffsetsTable != null && rowOffsetsTable instanceof LogicalTable) {
            rowOffsets = ((LogicalTable)rowOffsetsTable).getRowOffset();
        }
        if (rowOffsets == null && columnOffsets == null) {
            return LogicalTableHelper.logicalTable(table);
        }
        return new LogicalTable(table, columnOffsets, rowOffsets);
    }

    public static ILogicalTable logicalTable(IGridTable table) {
        int width = LogicalTableHelper.calcLogicalColumns(table);
        int height = LogicalTableHelper.calcLogicalRows(table);
        if (width == table.getWidth() && height == table.getHeight()) {
            return new SimpleLogicalTable(table);
        }
        return new LogicalTable(table, width, height);
    }

    public static ILogicalTable mergeBounds(ILogicalTable leftRows, ILogicalTable topColumns) {
        int i;
        int cLeft;
        IGridTable leftRowsGrid = leftRows.getSource();
        if (!leftRowsGrid.isNormalOrientation()) {
            throw new RuntimeException("Left Rows must have Normal Orientation");
        }
        IGridTable topColumnsGrid = topColumns.getSource();
        if (!topColumnsGrid.isNormalOrientation()) {
            throw new RuntimeException("Top Columns must have Normal Orientation");
        }
        IGridRegion leftRowsRegion = leftRowsGrid.getRegion();
        IGridRegion topColumnsRegion = topColumnsGrid.getRegion();
        int rLeft = leftRowsRegion.getRight() + 1;
        int left = cLeft = topColumnsRegion.getLeft();
        int startColumn = 0;
        if (cLeft < rLeft) {
            startColumn = topColumns.findColumnStart(rLeft - cLeft);
            left = rLeft;
        }
        int rTop = leftRowsRegion.getTop();
        int cTop = topColumnsRegion.getBottom() + 1;
        int top = rTop;
        int startRow = 0;
        if (rTop < cTop) {
            startRow = leftRows.findRowStart(cTop - rTop);
            top = cTop;
        }
        int right = topColumnsRegion.getRight();
        int bottom = leftRowsRegion.getBottom();
        if (right < left) {
            throw new RuntimeException("Invalid horizontal dimension");
        }
        if (bottom < top) {
            throw new RuntimeException("Invalid vertical dimension");
        }
        GridTable gt = new GridTable(top, left, bottom, right, leftRowsGrid.getGrid());
        int nRows = leftRows.getHeight() - startRow;
        int nColumns = topColumns.getWidth() - startColumn;
        if (gt.getHeight() == nRows && gt.getWidth() == nColumns) {
            return new SimpleLogicalTable(gt);
        }
        int[] rowsOffset = new int[nRows + 1];
        int[] columnsOffset = new int[nColumns + 1];
        int rOffset = 0;
        for (i = 0; i < nRows; ++i) {
            rowsOffset[i] = rOffset;
            rOffset += leftRows.getRowHeight(i + startRow);
        }
        rowsOffset[i] = rOffset;
        int cOffset = 0;
        for (i = 0; i < nColumns; ++i) {
            columnsOffset[i] = cOffset;
            cOffset += topColumns.getColumnWidth(i + startColumn);
        }
        columnsOffset[i] = cOffset;
        return new LogicalTable((IGridTable)gt, columnsOffset, rowsOffset);
    }

    public static ILogicalTable make1ColumnTable(ILogicalTable t) {
        if (t.getWidth() == 1) {
            return t;
        }
        if (t.getHeight() == 1) {
            return (ILogicalTable)t.transpose();
        }
        return t;
    }

    public static ILogicalTable unmergeColumns(ILogicalTable table, int fromColumn, int toColumn) {
        int gridFromOffset;
        IGridTable gt = table.getSource();
        int gridWidth = gt.getWidth();
        if (table.getWidth() == gridWidth) {
            return table;
        }
        int[] columnOffsets = LogicalTableHelper.getColumnOffsets(table);
        int gridToOffset = columnOffsets[toColumn];
        if (gridToOffset - (gridFromOffset = columnOffsets[fromColumn]) == toColumn - fromColumn) {
            return table;
        }
        int gridColumnsToUnmerge = gridToOffset - gridFromOffset;
        int restOfColumns = table.getWidth() - toColumn;
        int newWidth = fromColumn + gridColumnsToUnmerge + restOfColumns;
        int[] newColumnOffsets = new int[newWidth + 1];
        System.arraycopy(columnOffsets, 0, newColumnOffsets, 0, fromColumn);
        int offset = columnOffsets[fromColumn];
        for (int i = 0; i < gridColumnsToUnmerge; ++i) {
            newColumnOffsets[fromColumn + i] = offset++;
        }
        System.arraycopy(columnOffsets, toColumn, newColumnOffsets, fromColumn + gridColumnsToUnmerge, restOfColumns + 1);
        return new LogicalTable(gt, newColumnOffsets, LogicalTableHelper.getRowOffsets(table));
    }

    private static int[] getRowOffsets(ILogicalTable table) {
        if (table instanceof LogicalTable) {
            return ((LogicalTable)table).getRowOffset();
        }
        return LogicalTableHelper.calculateRowOffsets(table.getHeight(), table.getSource());
    }

    private static int[] getColumnOffsets(ILogicalTable table) {
        if (table instanceof LogicalTable) {
            return ((LogicalTable)table).getColumnOffset();
        }
        return LogicalTableHelper.calculateColumnOffsets(table.getWidth(), table.getSource());
    }

    public static int[] calculateColumnOffsets(int width, IGridTable gt) {
        int[] columnOffset = new int[width + 1];
        int offset = 0;
        int cellWidth = 0;
        for (int i = 0; i < width; ++i) {
            columnOffset[i] = offset;
            cellWidth = gt.getCell(offset, 0).getWidth();
            offset += cellWidth;
        }
        columnOffset[width] = offset;
        return columnOffset;
    }

    public static int[] calculateRowOffsets(int height, IGridTable gt) {
        int[] rowOffset = new int[height + 1];
        int offset = 0;
        int cellHeight = 0;
        for (int i = 0; i < height; ++i) {
            rowOffset[i] = offset;
            cellHeight = gt.getCell(0, offset).getHeight();
            offset += cellHeight;
        }
        rowOffset[height] = offset;
        return rowOffset;
    }
}

