/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.AGridTableDecorator;
import org.openl.rules.table.CoordinatesTransformer;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;

public class TransformedGridTable
extends AGridTableDecorator {
    private CoordinatesTransformer transformer;

    public TransformedGridTable(IGridTable gridTable, CoordinatesTransformer transformer) {
        super(gridTable);
        this.transformer = transformer;
    }

    public CoordinatesTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public ICell getCell(int column, int row) {
        return this.table.getCell(this.getColumn(column, row), this.getRow(column, row));
    }

    @Override
    public String getUri() {
        return this.table.getGrid().getUri();
    }

    private int getRow(int col, int row) {
        return this.transformer.getRow(col, row);
    }

    private int getColumn(int col, int row) {
        return this.transformer.getColumn(col, row);
    }

    @Override
    public int getWidth() {
        return this.transformer.getWidth();
    }

    @Override
    public int getHeight() {
        return this.transformer.getHeight();
    }

    @Override
    public int getGridRow(int column, int row) {
        return this.table.getGridRow(this.getColumn(column, row), this.getRow(column, row));
    }

    @Override
    public int getGridColumn(int column, int row) {
        return this.table.getGridColumn(this.getColumn(column, row), this.getRow(column, row));
    }

    @Override
    public boolean isNormalOrientation() {
        return this.table.isNormalOrientation();
    }
}

