/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.apache.commons.lang3.StringUtils;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;

public class UndoableSetValueAction
extends AUndoableCellAction {
    private Object newValue;

    public UndoableSetValueAction(int col, int row, Object value) {
        super(col, row);
        this.newValue = value;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        ICell cell = grid.getCell(this.getCol(), this.getRow());
        this.setPrevValue(cell.getObjectValue());
        this.setPrevFormula(cell.getFormula());
        grid.setCellValue(this.getCol(), this.getRow(), this.newValue);
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        if (StringUtils.isNotBlank((CharSequence)this.getPrevFormula())) {
            grid.setCellFormula(this.getCol(), this.getRow(), this.getPrevFormula());
        } else {
            grid.setCellValue(this.getCol(), this.getRow(), this.getPrevValue());
        }
    }
}

