/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.formatters;

import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.openl.rules.helpers.NumberUtils;
import org.openl.rules.table.formatters.ArrayFormatter;
import org.openl.rules.table.formatters.SmartNumberFormatter;
import org.openl.util.formatters.BooleanFormatter;
import org.openl.util.formatters.DateFormatter;
import org.openl.util.formatters.DefaultFormatter;
import org.openl.util.formatters.EnumFormatter;
import org.openl.util.formatters.FormatterAdapter;
import org.openl.util.formatters.IFormatter;
import org.openl.util.formatters.NumberFormatter;

public class FormattersManager {
    public static String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";
    public static String DEFAULT_NUMBER_FORMAT = "#.#################";

    static IFormatter getFormatter(Object value) {
        FormatterAdapter formatter;
        if (value != null) {
            Class<?> clazz = value.getClass();
            formatter = FormattersManager.getFormatter(clazz, value);
            if (formatter instanceof DefaultFormatter) {
                formatter = new FormatterAdapter();
            }
        } else {
            formatter = new FormatterAdapter();
        }
        return formatter;
    }

    public static String format(Object value) {
        return FormattersManager.getFormatter(value).format(value);
    }

    public static IFormatter getFormatter(Class<?> clazz, Object value, String format) {
        Object formatter;
        if (ClassUtils.isAssignable(clazz, Number.class, (boolean)true)) {
            if (StringUtils.isBlank((CharSequence)format) && NumberUtils.isFloatPointType(clazz)) {
                format = FormattersManager.getFormatForScale(value);
                return new SmartNumberFormatter(Locale.US);
            }
            String numberFormat = StringUtils.isNotBlank((CharSequence)format) ? format : DEFAULT_NUMBER_FORMAT;
            formatter = new NumberFormatter(numberFormat, Locale.US);
        } else if (clazz == Date.class) {
            String dateFormat = StringUtils.isNotBlank((CharSequence)format) ? format : DEFAULT_DATE_FORMAT;
            formatter = new DateFormatter(dateFormat);
        } else if (ClassUtils.isAssignable(clazz, Boolean.class, (boolean)true)) {
            formatter = new BooleanFormatter();
        } else if (clazz.isEnum()) {
            formatter = new EnumFormatter(clazz);
        } else if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            IFormatter componentFormatter = FormattersManager.getFormatter(componentType);
            formatter = new ArrayFormatter(componentFormatter);
        } else {
            formatter = new DefaultFormatter();
        }
        return formatter;
    }

    private static String getFormatForScale(Object value) {
        if (value != null) {
            int scale = NumberUtils.getScale((Number)value);
            StringBuilder buf = new StringBuilder();
            buf.append("#");
            if (scale > 0) {
                buf.append(".");
                for (int i = 0; i < scale; ++i) {
                    buf.append("#");
                }
            }
            return buf.toString();
        }
        return null;
    }

    public static IFormatter getFormatter(Class<?> clazz, Object value) {
        return FormattersManager.getFormatter(clazz, value, null);
    }

    public static IFormatter getFormatter(Class<?> clazz, String format) {
        return FormattersManager.getFormatter(clazz, null, format);
    }

    public static IFormatter getFormatter(Class<?> clazz) {
        return FormattersManager.getFormatter(clazz, null, null);
    }
}

