/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties;

import java.util.List;
import java.util.Map;
import org.openl.rules.method.ITablePropertiesMethod;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.MethodDelegator;

public class PropertiesHelper {
    public static final String PROPERTIES_HEADER = "properties";

    private PropertiesHelper() {
    }

    public static ILogicalTable getPropertiesTableSection(ILogicalTable table) {
        if (table.getHeight() < 2) {
            return null;
        }
        ILogicalTable propTable = (ILogicalTable)table.getRows(1, 1);
        String header = propTable.getSource().getCell(0, 0).getStringValue();
        if (!PROPERTIES_HEADER.equals(header)) {
            return null;
        }
        return (ILogicalTable)propTable.getColumns(1);
    }

    public static ITableProperties getTableProperties(IOpenMethod method) {
        if (method instanceof OpenMethodDispatcher) {
            List<IOpenMethod> methods = ((OpenMethodDispatcher)method).getCandidates();
            if (methods.size() == 1) {
                return PropertiesHelper.getTableProperties(methods.get(0));
            }
            throw new IllegalArgumentException("Dispatcher method with more than one candidate doesn't have properties!");
        }
        if (method instanceof ITablePropertiesMethod) {
            return ((ITablePropertiesMethod)method).getMethodProperties();
        }
        if (method.getInfo() != null) {
            TableProperties properties = new TableProperties();
            Map definedInTable = method.getInfo().getProperties();
            if (definedInTable != null) {
                for (Map.Entry property : definedInTable.entrySet()) {
                    properties.setFieldValue((String)property.getKey(), property.getValue());
                }
            }
            return properties;
        }
        if (method instanceof MethodDelegator) {
            return PropertiesHelper.getTableProperties(((MethodDelegator)method).getMethod());
        }
        return new TableProperties();
    }

    public static Map<String, Object> getMethodProperties(IOpenMethod method) {
        if (method instanceof ITablePropertiesMethod) {
            return ((ITablePropertiesMethod)method).getProperties();
        }
        if (method.getInfo() != null) {
            return method.getInfo().getProperties();
        }
        if (method instanceof MethodDelegator) {
            return PropertiesHelper.getMethodProperties(method.getMethod());
        }
        return null;
    }
}

