/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.def;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.table.properties.def.DefaultPropertyDefinitions;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;

public class TablePropertyDefinitionUtils {
    public static String[] getDimensionalTablePropertiesNames() {
        ArrayList<String> names = new ArrayList<String>();
        List<TablePropertyDefinition> dimensionalProperties = TablePropertyDefinitionUtils.getDimensionalTableProperties();
        for (TablePropertyDefinition definition : dimensionalProperties) {
            names.add(definition.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public static List<TablePropertyDefinition> getDimensionalTableProperties() {
        TablePropertyDefinition[] definitions;
        ArrayList<TablePropertyDefinition> dimensionalProperties = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition definition : definitions = DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!definition.isDimensional()) continue;
            dimensionalProperties.add(definition);
        }
        return dimensionalProperties;
    }

    public static String getPropertyName(String displayName) {
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.getDisplayName().equals(displayName)) continue;
            return propDefinition.getName();
        }
        return null;
    }

    public static String getPropertyDisplayName(String name) {
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.getName().equals(name)) continue;
            return propDefinition.getDisplayName();
        }
        return null;
    }

    public static TablePropertyDefinition getPropertyByName(String name) {
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.getName().equals(name)) continue;
            return propDefinition;
        }
        return null;
    }

    public static boolean doesPropertyExist(String name) {
        return TablePropertyDefinitionUtils.getPropertyByName(name) != null;
    }

    public static List<TablePropertyDefinition> getPropertiesToBeSetByDefault() {
        ArrayList<TablePropertyDefinition> result = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (propDefinition.getDefaultValue() == null) continue;
            result.add(propDefinition);
        }
        return result;
    }

    public static List<TablePropertyDefinition> getPropertiesToBeSetByDefault(String tableType) {
        if (tableType != null) {
            ArrayList<TablePropertyDefinition> result = new ArrayList<TablePropertyDefinition>();
            for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
                if (propDefinition.getDefaultValue() == null || !tableType.equals(propDefinition.getTableType())) continue;
                result.add(propDefinition);
            }
            return result;
        }
        return TablePropertyDefinitionUtils.getPropertiesToBeSetByDefault();
    }

    public static List<TablePropertyDefinition> getSystemProperties() {
        ArrayList<TablePropertyDefinition> result = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.isSystem()) continue;
            result.add(propDefinition);
        }
        return result;
    }

    public static TablePropertyDefinition[] getDefaultDefinitionsByInheritanceLevel(InheritanceLevel inheritanceLevel) {
        ArrayList<TablePropertyDefinition> resultDefinitions = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propertyDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!ArrayUtils.contains((Object[])propertyDefinition.getInheritanceLevel(), (Object)((Object)inheritanceLevel))) continue;
            resultDefinitions.add(propertyDefinition);
        }
        return resultDefinitions.toArray(new TablePropertyDefinition[0]);
    }

    public static TablePropertyDefinition[] getDefaultDefinitionsForTable(String tableType) {
        return TablePropertyDefinitionUtils.getDefaultDefinitionsForTable(tableType, null, false);
    }

    public static TablePropertyDefinition[] getDefaultDefinitionsForTable(String tableType, InheritanceLevel inheritanceLevel, boolean ignoreSystem) {
        ArrayList<TablePropertyDefinition> resultDefinitions = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propertyDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            String name = propertyDefinition.getName();
            if (!PropertiesChecker.isPropertySuitableForTableType(name, tableType) || inheritanceLevel != null && !ArrayUtils.contains((Object[])propertyDefinition.getInheritanceLevel(), (Object)((Object)inheritanceLevel)) || ignoreSystem && (!ignoreSystem || propertyDefinition.isSystem())) continue;
            resultDefinitions.add(propertyDefinition);
        }
        return resultDefinitions.toArray(new TablePropertyDefinition[resultDefinitions.size()]);
    }

    public static Map<String, List<TablePropertyDefinition>> groupProperties(TablePropertyDefinition[] properties) {
        LinkedHashMap<String, List<TablePropertyDefinition>> groups = new LinkedHashMap<String, List<TablePropertyDefinition>>();
        for (TablePropertyDefinition property : properties) {
            String groupName = property.getGroup();
            ArrayList<TablePropertyDefinition> group = (ArrayList<TablePropertyDefinition>)groups.get(groupName);
            if (group == null) {
                group = new ArrayList<TablePropertyDefinition>();
                groups.put(groupName, group);
            }
            group.add(property);
        }
        return groups;
    }

    public static XlsNodeTypes[] getSuitableTableTypes(String propertyName) {
        TablePropertyDefinition propDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyName);
        if (propDefinition != null) {
            return propDefinition.getTableType();
        }
        return null;
    }

    public static Class<?> getPropertyTypeByPropertyName(String name) {
        TablePropertyDefinition propDefinition = TablePropertyDefinitionUtils.getPropertyByName(name);
        if (propDefinition != null) {
            return propDefinition.getType().getInstanceClass();
        }
        return null;
    }
}

