/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.expressions.match;

import org.apache.commons.lang3.StringUtils;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.table.properties.expressions.match.AMatchingExpression;
import org.openl.rules.table.properties.expressions.match.ContainsMatchingExpression;
import org.openl.rules.table.properties.expressions.match.EQMatchingExpression;
import org.openl.rules.table.properties.expressions.match.GEMatchingExpression;
import org.openl.rules.table.properties.expressions.match.GTMatchingExpression;
import org.openl.rules.table.properties.expressions.match.IMatchingExpression;
import org.openl.rules.table.properties.expressions.match.LEMatchingExpression;
import org.openl.rules.table.properties.expressions.match.LTMatchingExpression;

public class MatchingExpressionFactory {
    private MatchingExpressionFactory() {
    }

    public static IMatchingExpression getMatchingExpression(String operationName, String contextAttribute) {
        AMatchingExpression matchExpression = null;
        String string = operationName = operationName == null ? "" : operationName;
        if (StringUtils.isEmpty((CharSequence)contextAttribute)) {
            throw new OpenLRuntimeException("Can`t create matching expression with empty context attribute");
        }
        if ("LT".equalsIgnoreCase(operationName)) {
            matchExpression = new LTMatchingExpression(contextAttribute);
        } else if ("LE".equalsIgnoreCase(operationName)) {
            matchExpression = new LEMatchingExpression(contextAttribute);
        } else if ("GT".equalsIgnoreCase(operationName)) {
            matchExpression = new GTMatchingExpression(contextAttribute);
        } else if ("GE".equalsIgnoreCase(operationName)) {
            matchExpression = new GEMatchingExpression(contextAttribute);
        } else if ("EQ".equalsIgnoreCase(operationName)) {
            matchExpression = new EQMatchingExpression(contextAttribute);
        } else if ("CONTAINS".equalsIgnoreCase(operationName)) {
            matchExpression = new ContainsMatchingExpression(contextAttribute);
        } else {
            throw new OpenLRuntimeException(String.format("Unknown match expression operation \"%s\"", operationName));
        }
        return matchExpression;
    }
}

