/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.expressions.match;

import org.apache.commons.lang3.StringUtils;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.table.properties.expressions.match.IMatchingExpression;
import org.openl.rules.table.properties.expressions.match.MatchingExpressionFactory;

public class MatchingExpressionsParser {
    private MatchingExpressionsParser() {
    }

    public static IMatchingExpression parse(String matchingExpressionStr) {
        int closeBracketIndex;
        int openBracketIndex;
        String operationName = null;
        String contextAttribute = null;
        if (StringUtils.isNotEmpty((CharSequence)matchingExpressionStr)) {
            openBracketIndex = matchingExpressionStr.indexOf("(");
            closeBracketIndex = matchingExpressionStr.lastIndexOf(")");
            if (openBracketIndex < 0 || closeBracketIndex < 0) {
                throw new OpenLRuntimeException("Matching expression string is not valid");
            }
        } else {
            throw new OpenLRuntimeException("Matching expression string is null");
        }
        operationName = matchingExpressionStr.substring(0, openBracketIndex).toUpperCase();
        contextAttribute = matchingExpressionStr.substring(openBracketIndex + 1, closeBracketIndex);
        if (StringUtils.isEmpty((CharSequence)operationName) || StringUtils.isEmpty((CharSequence)contextAttribute)) {
            throw new OpenLRuntimeException("Wrong matching expression format. Expected: <operationName>(<contextAttribute>) or MAX|MIN(LE|GE(<contextAttribute>))");
        }
        return MatchingExpressionFactory.getMatchingExpression(operationName, contextAttribute);
    }
}

