/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.inherit;

import java.util.Arrays;
import java.util.Set;
import org.openl.binding.impl.BindHelper;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesChecker {
    public static void checkProperties(Set<String> propertyNamesToCheck, TableSyntaxNode tableSyntaxNode, InheritanceLevel level) {
        PropertiesChecker.checkPropertiesLevel(propertyNamesToCheck, tableSyntaxNode, level);
        PropertiesChecker.checkPropertiesForTableType(propertyNamesToCheck, tableSyntaxNode);
        PropertiesChecker.checkForDeprecation(propertyNamesToCheck, tableSyntaxNode);
    }

    private static void checkPropertiesLevel(Set<String> propertyNamesToCheck, TableSyntaxNode tableSyntaxNode, InheritanceLevel level) {
        if (level == null) {
            return;
        }
        for (String propertyNameToCheck : propertyNamesToCheck) {
            if (PropertiesChecker.isPropertySuitableForLevel(level, propertyNameToCheck)) continue;
            String message = String.format("Property '%s' can`t be defined on the '%s' level", propertyNameToCheck, level.getDisplayName());
            PropertiesChecker.addError(tableSyntaxNode, message);
        }
    }

    private static void checkPropertiesForTableType(Set<String> propertyNamesToCheck, TableSyntaxNode tableSyntaxNode) {
        String tableType = tableSyntaxNode.getType();
        for (String propertyNameToCheck : propertyNamesToCheck) {
            if (PropertiesChecker.isPropertySuitableForTableType(propertyNameToCheck, tableType)) continue;
            String message = String.format("Property '%s' can`t be defined in table of type '%s'", propertyNameToCheck, tableType);
            PropertiesChecker.addError(tableSyntaxNode, message);
        }
    }

    private static void addError(TableSyntaxNode tableSyntaxNode, String message) {
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableSyntaxNode);
        tableSyntaxNode.addError(error);
        BindHelper.processError((SyntaxNodeException)error);
    }

    private static void checkForDeprecation(Set<String> propertyNamesToCheck, TableSyntaxNode tableSyntaxNode) {
        for (String propertyNameToCheck : propertyNamesToCheck) {
            TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyNameToCheck);
            if (propertyDefinition.getDeprecation() == null || propertyDefinition.getDeprecation().isEmpty()) continue;
            String message = String.format("Property '%s' was deprecated. Please remove it!", propertyNameToCheck);
            OpenLMessagesUtils.addWarn((String)message, (ISyntaxNode)tableSyntaxNode);
        }
    }

    public static boolean isPropertySuitableForLevel(InheritanceLevel currentLevel, String propertyName) {
        Logger log = LoggerFactory.getLogger(PropertiesChecker.class);
        boolean result = false;
        TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyName);
        if (propertyDefinition != null) {
            InheritanceLevel[] inheritanceLevels = propertyDefinition.getInheritanceLevel();
            if (inheritanceLevels != null && inheritanceLevels.length > 0) {
                if (Arrays.asList(inheritanceLevels).contains((Object)currentLevel)) {
                    result = true;
                }
            } else {
                log.debug("Inheritance levels were not defined for property with name [{}].", (Object)propertyName);
            }
        } else {
            log.debug("There is no such property in Definitions with name [{}].", (Object)propertyName);
        }
        return result;
    }

    public static boolean isPropertySuitableForTableType(String propertyName, String tableType) {
        XlsNodeTypes[] definitionTableTypes = TablePropertyDefinitionUtils.getSuitableTableTypes(propertyName);
        if (definitionTableTypes != null && definitionTableTypes.length > 0) {
            for (XlsNodeTypes nodeType : definitionTableTypes) {
                if (!nodeType.toString().equals(tableType)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

