/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.syntax;

import org.openl.rules.table.IGridTable;
import org.openl.rules.table.syntax.GridPosition;
import org.openl.util.text.ILocation;
import org.openl.util.text.IPosition;

public class GridLocation
implements ILocation {
    private GridPosition start;
    private GridPosition end;

    public GridLocation(IGridTable table) {
        int width = table.getWidth();
        int height = table.getHeight();
        this.start = new GridPosition(table.getGridColumn(0, 0), table.getGridRow(0, 0), table.getGrid());
        this.end = new GridPosition(table.getGridColumn(width - 1, height - 1), table.getGridRow(width - 1, height - 1), table.getGrid());
    }

    public IPosition getEnd() {
        return this.end;
    }

    public IPosition getStart() {
        return this.start;
    }

    public boolean isTextLocation() {
        return false;
    }

    public String toString() {
        if (this.end == null) {
            return "cell=" + this.start;
        }
        return "range=" + this.start + ":" + this.end;
    }
}

