/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui.filters;

import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.ui.CellStyle;
import org.openl.rules.table.ui.IGridSelector;
import org.openl.rules.table.ui.filters.AGridFilter;

public class CellStyleGridFilter
extends AGridFilter {
    private static final int BORDER_SIDES_COUNT = 4;
    private Integer horizontalAlignment;
    private Integer verticalAlignment;
    private short[] fillBackgroundColor;
    private short[] fillForegroundColor;
    private Short fillBackgroundColorIndex;
    private Short fillForegroundColorIndex;
    private Short fillPattern;
    private Short[] borderStyle;
    private short[][] borderRGB;
    private Integer ident;
    private Boolean wrappedText;
    private Integer rotation;

    protected CellStyleGridFilter(IGridSelector selector, Integer horizontalAlignment, Integer verticalAlignment, short[] fillBackgroundColor, short[] fillForegroundColor, Short fillBackgroundColorIndex, Short fillForegroundColorIndex, Short fillPattern, Short[] borderStyle, short[][] borderRGB, Integer ident, Boolean wrappedText, Integer rotation) {
        super(selector);
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.fillBackgroundColor = fillBackgroundColor;
        this.fillForegroundColor = fillForegroundColor;
        this.fillBackgroundColorIndex = fillBackgroundColorIndex;
        this.fillForegroundColorIndex = fillForegroundColorIndex;
        this.fillPattern = fillPattern;
        this.borderStyle = borderStyle;
        this.borderRGB = borderRGB;
        this.ident = ident;
        this.wrappedText = wrappedText;
        this.rotation = rotation;
    }

    private CellStyleGridFilter(Builder builder) {
        this(builder.selector, builder.horizontalAlignment, builder.verticalAlignment, builder.fillBackgroundColor, builder.fillForegroundColor, builder.fillBackgroundColorIndex, builder.fillForegroundColorIndex, builder.fillPattern, builder.borderStyle, builder.borderRGB, builder.ident, builder.wrappedText, builder.rotation);
    }

    @Override
    public FormattedCell filterFormat(FormattedCell cell) {
        CellStyle style = (CellStyle)cell.getStyle();
        if (this.horizontalAlignment != null) {
            style.setHorizontalAlignment(this.horizontalAlignment);
        }
        if (this.verticalAlignment != null) {
            style.setVerticalAlignment(this.verticalAlignment);
        }
        if (this.fillBackgroundColor != null) {
            style.setFillBackgroundColor(this.fillBackgroundColor);
        }
        if (this.fillForegroundColor != null) {
            style.setFillForegroundColor(this.fillForegroundColor);
        }
        if (this.fillBackgroundColorIndex != null) {
            style.setFillForegroundColorIndex(this.fillBackgroundColorIndex);
        }
        if (this.fillForegroundColorIndex != null) {
            style.setFillForegroundColorIndex(this.fillForegroundColorIndex);
        }
        if (this.fillPattern != null) {
            style.setFillPattern(this.fillPattern);
        }
        if (this.borderStyle != null) {
            if (style.getBorderStyle() != null) {
                for (int i = 0; i < this.borderStyle.length; ++i) {
                    Short border = this.borderStyle[i];
                    if (border != null) continue;
                    this.borderStyle[i] = style.getBorderStyle()[i];
                }
            }
            style.setBorderStyle(this.toPrimitive(this.borderStyle));
        }
        if (this.borderRGB != null) {
            style.setBorderRGB(this.borderRGB);
        }
        if (this.ident != null) {
            style.setIdent(this.ident);
        }
        if (this.wrappedText != null) {
            style.setWrappedText(this.wrappedText);
        }
        if (this.rotation != null) {
            style.setRotation(this.rotation);
        }
        return cell;
    }

    public CellStyleGridFilter createUpperRowBorderFilter() {
        IGridSelector upperRowSelector = new IGridSelector(){

            @Override
            public boolean selectCoords(int col, int row) {
                return CellStyleGridFilter.this.getGridSelector().selectCoords(col, row + 1) && !CellStyleGridFilter.this.getGridSelector().selectCoords(col, row);
            }
        };
        Short[] bottomBorderStyle = new Short[4];
        bottomBorderStyle[2] = 0;
        short[][] bottomRGB = new short[4][];
        bottomRGB[2] = this.borderRGB[0];
        return new Builder().setSelector(upperRowSelector).setBorderStyle(bottomBorderStyle).setBorderRGB(bottomRGB).build();
    }

    public CellStyleGridFilter createLefterColumnBorderFilter() {
        IGridSelector upperRowSelector = new IGridSelector(){

            @Override
            public boolean selectCoords(int col, int row) {
                return CellStyleGridFilter.this.getGridSelector().selectCoords(col + 1, row) && !CellStyleGridFilter.this.getGridSelector().selectCoords(col, row);
            }
        };
        Short[] bottomBorderStyle = new Short[4];
        bottomBorderStyle[1] = 0;
        short[][] bottomRGB = new short[4][];
        bottomRGB[1] = this.borderRGB[3];
        return new Builder().setSelector(upperRowSelector).setBorderStyle(bottomBorderStyle).setBorderRGB(bottomRGB).build();
    }

    private short[] toPrimitive(Short[] array) {
        short[] primitive = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            primitive[i] = array[i] != null ? array[i] : (short)0;
        }
        return primitive;
    }

    public static class Builder {
        private IGridSelector selector;
        private Integer horizontalAlignment;
        private Integer verticalAlignment;
        private short[] fillBackgroundColor;
        private short[] fillForegroundColor;
        private Short fillBackgroundColorIndex;
        private Short fillForegroundColorIndex;
        private Short fillPattern;
        private Short[] borderStyle;
        private short[][] borderRGB;
        private Integer ident;
        private Boolean wrappedText;
        private Integer rotation;

        public Builder setSelector(IGridSelector selector) {
            if (selector == null) {
                throw new IllegalArgumentException("selector can't be null");
            }
            this.selector = selector;
            return this;
        }

        public Builder setHorizontalAlignment(int horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            return this;
        }

        public Builder setVerticalAlignment(int verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
            return this;
        }

        public Builder setFillBackgroundColor(short[] fillBackgroundColor) {
            if (fillBackgroundColor == null) {
                throw new IllegalArgumentException("fillBackgroundColor can't be null");
            }
            this.fillBackgroundColor = fillBackgroundColor;
            return this;
        }

        public Builder setFillForegroundColor(short[] fillForegroundColor) {
            if (fillForegroundColor == null) {
                throw new IllegalArgumentException("fillForegroundColor can't be null");
            }
            this.fillForegroundColor = fillForegroundColor;
            return this;
        }

        public Builder setFillBackgroundColorIndex(short fillBackgroundColorIndex) {
            this.fillBackgroundColorIndex = fillBackgroundColorIndex;
            return this;
        }

        public Builder setFillForegroundColorIndex(short fillForegroundColorIndex) {
            this.fillForegroundColorIndex = fillForegroundColorIndex;
            return this;
        }

        public Builder setFillPattern(short fillPattern) {
            this.fillPattern = fillPattern;
            return this;
        }

        public Builder setBorderStyle(Short[] borderStyle) {
            if (borderStyle == null) {
                throw new IllegalArgumentException("borderStyle can't be null");
            }
            this.borderStyle = borderStyle;
            return this;
        }

        public Builder setBorderStyle(short borderStyles) {
            return this.setBorderStyle(this.createBorderStyle(borderStyles));
        }

        public Builder setBorderRGB(short[][] borderRGB) {
            if (borderRGB == null) {
                throw new IllegalArgumentException("borderRGB can't be null");
            }
            this.borderRGB = borderRGB;
            return this;
        }

        public Builder setBorderRGB(short[] rgb) {
            if (rgb == null) {
                throw new IllegalArgumentException("rgb can't be null");
            }
            return this.setBorderRGB(this.createBorderRGB(rgb));
        }

        public Builder setIdent(int ident) {
            this.ident = ident;
            return this;
        }

        public Builder setWrappedText(boolean wrappedText) {
            this.wrappedText = wrappedText;
            return this;
        }

        public Builder setRotation(int rotation) {
            this.rotation = rotation;
            return this;
        }

        public CellStyleGridFilter build() {
            return new CellStyleGridFilter(this);
        }

        private Short[] createBorderStyle(short style) {
            Short[] colors = new Short[4];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = style;
            }
            return colors;
        }

        private short[][] createBorderRGB(short[] rgb) {
            short[][] colors = new short[4][];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = rgb;
            }
            return colors;
        }
    }
}

