/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui.filters;

import java.util.HashMap;
import java.util.Map;
import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.Point;
import org.openl.rules.table.formatters.FormattersManager;
import org.openl.rules.table.ui.filters.AGridFilter;
import org.openl.rules.testmethod.IParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestUnitResultComparator;
import org.openl.rules.testmethod.result.ComparedResult;

public class ExpectedResultFilter
extends AGridFilter {
    private Map<Point, ComparedResult> spreadsheetCellsForTest;

    public ExpectedResultFilter(Map<Point, ComparedResult> spreadsheetCellsForTest) {
        this.spreadsheetCellsForTest = new HashMap<Point, ComparedResult>(spreadsheetCellsForTest);
    }

    @Override
    public FormattedCell filterFormat(FormattedCell cell) {
        Point cellCoordinates = new Point(cell.getAbsoluteColumn(), cell.getAbsoluteRow());
        if (this.spreadsheetCellsForTest.containsKey(cellCoordinates)) {
            boolean isOk;
            ComparedResult result = this.spreadsheetCellsForTest.get(cellCoordinates);
            StringBuilder formattedValue = new StringBuilder(60);
            boolean bl = isOk = result.getStatus() == TestUnitResultComparator.TestStatus.TR_OK;
            if (isOk) {
                formattedValue.append("<i class=\"case-success\"></i> ").append(cell.getFormattedValue());
            } else {
                String formattedExpectedValue;
                Object expectedValue = result.getExpectedValue();
                if (expectedValue instanceof IParameterWithValueDeclaration) {
                    IParameterWithValueDeclaration declaration = (IParameterWithValueDeclaration)expectedValue;
                    expectedValue = declaration.getValue();
                }
                if ((formattedExpectedValue = FormattersManager.format(expectedValue)) == null || formattedExpectedValue.isEmpty() || expectedValue == null) {
                    formattedExpectedValue = "<span class=\"case-empty\">Empty</span>";
                }
                formattedValue.append("<i class=\"case-error\"></i> ").append(cell.getFormattedValue()).append(' ').append("<span class=\"case-expected\">Expected: </span>").append(formattedExpectedValue);
            }
            cell.setFormattedValue(formattedValue.toString());
        }
        return cell;
    }
}

