/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui.filters;

import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.ui.CellFont;
import org.openl.rules.table.ui.IGridSelector;
import org.openl.rules.table.ui.filters.AGridFilter;

public class FontGridFilter
extends AGridFilter {
    private short[] fontColor;
    private Integer size;
    private Integer incrementSize;
    private String name;
    private Boolean italic;
    private Boolean bold;
    private Boolean underlined;
    private Boolean strikeout;

    protected FontGridFilter(IGridSelector selector, short[] fontColor, Integer size, Integer incrementSize, String name, Boolean italic, Boolean bold, Boolean underlined, Boolean strikeout) {
        super(selector);
        this.fontColor = fontColor;
        this.size = size;
        this.incrementSize = incrementSize;
        this.name = name;
        this.italic = italic;
        this.bold = bold;
        this.underlined = underlined;
        this.strikeout = strikeout;
    }

    private FontGridFilter(Builder builder) {
        this(builder.selector, builder.fontColor, builder.size, builder.incrementSize, builder.name, builder.italic, builder.bold, builder.underlined, builder.strikeout);
    }

    @Override
    public FormattedCell filterFormat(FormattedCell cell) {
        CellFont font = (CellFont)cell.getFont();
        if (this.fontColor != null) {
            font.setFontColor(this.fontColor);
        }
        if (this.size != null) {
            font.setSize(this.size);
        }
        if (this.incrementSize != null) {
            font.setSize(font.getSize() + this.incrementSize);
        }
        if (this.name != null) {
            font.setName(this.name);
        }
        if (this.italic != null) {
            font.setItalic(this.italic);
        }
        if (this.bold != null) {
            font.setBold(this.bold);
        }
        if (this.underlined != null) {
            font.setUnderlined(this.underlined);
        }
        if (this.strikeout != null) {
            font.setStrikeout(this.strikeout);
        }
        return cell;
    }

    public static class Builder {
        private IGridSelector selector;
        private short[] fontColor;
        private Integer size;
        private Integer incrementSize;
        private String name;
        private Boolean italic;
        private Boolean bold;
        private Boolean underlined;
        private Boolean strikeout;

        public Builder setSelector(IGridSelector selector) {
            if (selector == null) {
                throw new IllegalArgumentException("selector can't be null");
            }
            this.selector = selector;
            return this;
        }

        public Builder setFontColor(short[] fontColor) {
            if (fontColor == null) {
                throw new IllegalArgumentException("fontColor can't be null");
            }
            this.fontColor = fontColor;
            return this;
        }

        public Builder setSize(int size) {
            this.size = size;
            return this;
        }

        public Builder setIncrementSize(int incrementSize) {
            this.incrementSize = incrementSize;
            return this;
        }

        public Builder setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name can't be null");
            }
            this.name = name;
            return this;
        }

        public Builder setItalic(boolean italic) {
            this.italic = italic;
            return this;
        }

        public Builder setBold(boolean bold) {
            this.bold = bold;
            return this;
        }

        public Builder setUnderlined(boolean underlined) {
            this.underlined = underlined;
            return this;
        }

        public Builder setStrikeout(boolean strikeout) {
            this.strikeout = strikeout;
            return this;
        }

        public FontGridFilter build() {
            if (this.size != null && this.incrementSize != null) {
                throw new IllegalArgumentException("Only one of \"size\" and \"incrementSize\" paremeters should be initialized");
            }
            return new FontGridFilter(this);
        }
    }
}

