/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.builder;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.DataTableField;
import org.openl.rules.table.xls.builder.TableBuilder;

public class DataTableBuilder
extends TableBuilder {
    public static final int MIN_WIDTH = 1;
    private static final int NOT_INITIALIZED = -1;
    private List<? extends DataTableField> fields;
    private int fieldNameRow = -1;
    private int foreignKeyRow = -1;
    private int businessNameRow = -1;

    public DataTableBuilder(XlsSheetGridModel gridModel) {
        super(gridModel);
    }

    public void writeHeader(String typeName, String variableName, ICellStyle style) {
        String header = "Data";
        if (StringUtils.isNotBlank((CharSequence)typeName)) {
            header = header + " " + typeName;
        }
        if (StringUtils.isNotBlank((CharSequence)variableName)) {
            header = header + " " + variableName;
        }
        super.writeHeader(header, style);
    }

    public void writeHeader(String typeName, String variableName) {
        this.writeHeader(typeName, variableName, null);
    }

    public void writeFieldNames(List<? extends DataTableField> fields) {
        if (this.getTableRegion() == null) {
            throw new IllegalStateException("beginTable() has to be called");
        }
        this.fields = fields;
        boolean hasForeignKeys = this.hasForeignKeys(fields);
        this.fieldNameRow = this.getCurrentRow();
        this.foreignKeyRow = hasForeignKeys ? this.fieldNameRow + 1 : -1;
        this.businessNameRow = hasForeignKeys ? this.fieldNameRow + 2 : this.fieldNameRow + 1;
        this.writeFields("", fields, 0);
        this.incCurrentRow(hasForeignKeys ? 3 : 2);
    }

    public void writeFieldValues(Map<String, String> fieldValues, ICellStyle cellStyle) {
        this.writeFieldValues(this.fields, fieldValues, cellStyle);
        this.incCurrentRow();
    }

    private boolean hasForeignKeys(List<? extends DataTableField> fields) {
        for (DataTableField dataTableField : fields) {
            boolean hasForeignKey;
            if (dataTableField.isFillChildren()) {
                hasForeignKey = this.hasForeignKeys(dataTableField.getAggregatedFields());
            } else {
                boolean bl = hasForeignKey = !StringUtils.isBlank((CharSequence)dataTableField.getForeignKey());
            }
            if (!hasForeignKey) continue;
            return true;
        }
        return false;
    }

    private int writeFields(String prefix, List<? extends DataTableField> fields, int column) {
        int col = column;
        for (DataTableField dataTableField : fields) {
            if (StringUtils.isBlank((CharSequence)dataTableField.getName())) {
                throw new IllegalArgumentException("Field name must be not empty");
            }
            if (dataTableField.isFillChildren()) {
                col = this.writeFields(prefix + dataTableField.getName() + ".", dataTableField.getAggregatedFields(), col);
                continue;
            }
            this.writeCell(col, this.fieldNameRow, 1, 1, prefix + dataTableField.getName());
            if (this.foreignKeyRow != -1) {
                this.writeCell(col, this.foreignKeyRow, 1, 1, this.parseForeignKey(dataTableField.getForeignKey()));
            }
            this.writeCell(col, this.businessNameRow, 1, 1, dataTableField.getBusinessName());
            ++col;
        }
        return col;
    }

    private String parseForeignKey(String foreignKey) {
        if (!StringUtils.isBlank((CharSequence)foreignKey)) {
            if (foreignKey.startsWith(">")) {
                return foreignKey;
            }
            int dotPos = foreignKey.indexOf(".");
            String tableName = dotPos > 0 ? foreignKey.substring(0, dotPos) : foreignKey;
            String columnName = dotPos > 0 ? " " + foreignKey.substring(dotPos + 1) : "";
            return ">" + tableName + columnName;
        }
        return "";
    }

    private void writeFieldValues(List<? extends DataTableField> fields, Map<String, String> fieldValues, ICellStyle cellStyle) {
        for (int i = 0; i < fields.size(); ++i) {
            DataTableField field = fields.get(i);
            if (field.isFillChildren()) {
                this.writeFieldValues(field.getAggregatedFields(), fieldValues, cellStyle);
                continue;
            }
            String fieldName = field.getName();
            this.writeCell(i, this.getCurrentRow(), 1, 1, fieldValues.get(fieldName), cellStyle);
        }
    }
}

