/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.builder;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.TableBuilder;

public class PropertiesTableBuilder
extends TableBuilder {
    public static final int MIN_WIDTH = 2;

    public PropertiesTableBuilder(XlsSheetGridModel gridModel) {
        super(gridModel);
    }

    public void beginTable(int height) throws CreateTableException {
        super.beginTable(2, height);
    }

    public void writeBody(Map<String, Object> properties, ICellStyle style) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must be not null");
        }
        if (this.getTableRegion() == null) {
            throw new IllegalStateException("beginTable() has to be called");
        }
        Set<String> keys = properties.keySet();
        for (String key : keys) {
            this.writeCell(0, this.getCurrentRow(), 1, 1, key, style);
            Object value = properties.get(key);
            this.writeCell(1, this.getCurrentRow(), 1, 1, value, style);
            this.incCurrentRow();
        }
    }

    public void writeBody(Map<String, Object> properties) {
        this.writeBody(properties, null);
    }

    @Override
    public void writeHeader(String tableName, ICellStyle style) {
        String header = "Properties";
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            header = header + " " + tableName;
        }
        super.writeHeader(header, style);
    }

    public void writeHeader(String tableName) {
        this.writeHeader(tableName, null);
    }
}

