/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.writers;

import org.openl.rules.table.xls.PoiExcelHelper;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.writers.AXlsCellWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsCellFormulaWriter
extends AXlsCellWriter {
    private final Logger log = LoggerFactory.getLogger(XlsCellFormulaWriter.class);

    public XlsCellFormulaWriter(XlsSheetGridModel xlsSheetGridModel) {
        super(xlsSheetGridModel);
    }

    @Override
    public void writeCellValue(boolean writeMetaInfo) {
        String formula = this.getStringValue();
        try {
            this.writeExcelFormula(formula.replaceFirst("=", ""));
        }
        catch (Exception e) {
            this.writeOpenLFormula(formula);
        }
        if (writeMetaInfo) {
            this.setMetaInfo(String.class);
        }
    }

    private void writeExcelFormula(String formula) {
        this.getCellToWrite().setCellFormula(formula);
        try {
            PoiExcelHelper.evaluateFormula(this.getCellToWrite());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void writeOpenLFormula(String formula) {
        this.getCellToWrite().setCellType(1);
        this.getCellToWrite().setCellValue(formula);
    }
}

