/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.AlgorithmRow;
import org.openl.rules.tbasic.TableParserSpecificationBean;

public class AlgorithmTreeNode {
    private AlgorithmRow algorithmRow;
    private TableParserSpecificationBean specification;
    private final List<StringValue> labels;
    private final List<AlgorithmTreeNode> children = new ArrayList<AlgorithmTreeNode>();

    public AlgorithmTreeNode() {
        this.labels = new LinkedList<StringValue>();
    }

    public void add(AlgorithmTreeNode node) {
        this.children.add(node);
    }

    public void addLabel(StringValue label) {
        if (!label.equals((Object)"")) {
            this.labels.add(label);
        }
    }

    public AlgorithmRow getAlgorithmRow() {
        return this.algorithmRow;
    }

    public List<AlgorithmTreeNode> getChildren() {
        return this.children;
    }

    public List<StringValue> getLabels() {
        return this.labels;
    }

    public TableParserSpecificationBean getSpecification() {
        return this.specification;
    }

    public String getSpecificationKeyword() {
        if (this.specification != null) {
            return this.specification.getKeyword();
        }
        return null;
    }

    public void setAlgorithmRow(AlgorithmRow algorithmRow) {
        this.algorithmRow = algorithmRow;
    }

    public void setSpecification(TableParserSpecificationBean specification) {
        this.specification = specification;
    }

    public String toString() {
        if (this.specification != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("Specification Keyword : ");
            buf.append(this.specification.getKeyword());
            if (this.algorithmRow != null) {
                buf.append(". Row : ");
                buf.append(this.algorithmRow);
            }
            return buf.toString();
        }
        return super.toString();
    }
}

