/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.openl.rules.tbasic.TBasicSpecificationKey;

public class LabelManager {
    private static final String LABEL_INSTRUCTION_PREFIX = "gen_label_";
    private Map<LabelType, String> currentLabels;
    private boolean isLoopOperationSet;
    private Stack<Map<LabelType, String>> labelsStack = new Stack();
    private int nextLabelNumber;

    public void finishOperationsSet() {
        this.currentLabels = null;
        if (!this.labelsStack.isEmpty()) {
            this.currentLabels = this.labelsStack.pop();
        }
    }

    public void generateAllLabels(String[] labelInstructions) {
        for (String labelInstruction : labelInstructions) {
            if (labelInstruction == null) continue;
            LabelType labelType = this.getLabelType(labelInstruction);
            this.generateLabel(labelType);
        }
    }

    public String generateLabel(LabelType labelType) {
        String namePrefix = labelType.getName();
        String label = namePrefix + "Label" + this.nextLabelNumber++;
        this.currentLabels.put(labelType, label);
        return label;
    }

    private String getExistingLabel(Map<LabelType, String> existingLabels, LabelType labelType) {
        String label = null;
        if (existingLabels.containsKey(labelType)) {
            label = existingLabels.get(labelType);
        } else if (!this.isLoopOperationSet && labelType.isLoopLabel()) {
            label = this.getLabelFromStack(labelType);
        }
        return label;
    }

    public String getLabelByInstruction(String labelInstruction) {
        LabelType labelType = this.getLabelType(labelInstruction);
        String label = this.getExistingLabel(this.currentLabels, labelType);
        if (label == null) {
            label = this.generateLabel(labelType);
        }
        return label;
    }

    private String getLabelFromStack(LabelType labelType) {
        if (this.labelsStack.isEmpty()) {
            throw new RuntimeException("Smth wrong in labels.....");
        }
        Map<LabelType, String> stackedLabels = this.labelsStack.pop();
        String label = this.getExistingLabel(stackedLabels, labelType);
        this.labelsStack.push(stackedLabels);
        return label;
    }

    private LabelType getLabelType(String labelInstruction) {
        if (!this.isLabelInstruction(labelInstruction)) {
            throw new RuntimeException("Smth wrong.........");
        }
        LabelType labelType = this.getLabelTypeByInstruction(labelInstruction);
        return labelType;
    }

    private LabelType getLabelTypeByInstruction(String labelInstruction) {
        String instruction = labelInstruction.substring(LABEL_INSTRUCTION_PREFIX.length());
        String loopKeyword = "loop";
        String[] instructionParts = instruction.split("_");
        LabelType labelType = new LabelType();
        if (instructionParts.length < 1 || instructionParts.length > 2 || instructionParts.length == 2 && !loopKeyword.equals(instructionParts[1])) {
            throw new RuntimeException("Bad gen label instruction....");
        }
        labelType.setLabelType(instructionParts[0]);
        if (instructionParts.length > 1) {
            labelType.setLoopLabel(loopKeyword.equals(instructionParts[1]));
        }
        return labelType;
    }

    public boolean isLabelInstruction(String labelInstruction) {
        return labelInstruction.startsWith(LABEL_INSTRUCTION_PREFIX);
    }

    public void startOperationsSet(boolean isLoopOperationSet) {
        if (this.currentLabels != null) {
            this.labelsStack.push(this.currentLabels);
        }
        this.currentLabels = new HashMap<LabelType, String>();
        this.isLoopOperationSet = isLoopOperationSet;
    }

    public boolean isReturnInstruction(String labelInstruction) {
        return labelInstruction.startsWith(TBasicSpecificationKey.RETURN.toString());
    }

    private class LabelType {
        private boolean loopLabel;
        private String name;

        private LabelType() {
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof LabelType)) {
                return false;
            }
            LabelType otherLabelType = (LabelType)other;
            return this.name.equals(otherLabelType.name) && this.loopLabel == otherLabelType.loopLabel;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode() + (this.loopLabel ? 11 : 0);
        }

        public boolean isLoopLabel() {
            return this.loopLabel;
        }

        public void setLabelType(String labelType) {
            this.name = labelType;
        }

        public void setLoopLabel(boolean isLoopLabel) {
            this.loopLabel = isLoopLabel;
        }
    }
}

